/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;

@Rule(key="S6810")
public class AsyncMethodsReturnTypeCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        TypeTree returnType;
        MethodTree mt = (MethodTree)tree;
        if (mt.symbol().metadata().isAnnotatedWith("org.springframework.scheduling.annotation.Async") && !(returnType = mt.returnType()).symbolType().isVoid() && !returnType.symbolType().isSubtypeOf("java.util.concurrent.Future")) {
            this.reportIssue((Tree)returnType, "Async methods should return 'void' or a 'Future' type.");
        }
    }
}

