/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.naming;

import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.helpers.UnitTestUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3578")
public class BadTestMethodNameCheck
extends IssuableSubscriptionVisitor {
    private static final String DEFAULT_FORMAT = "^test[A-Z][a-zA-Z0-9]*$";
    @RuleProperty(key="format", description="Regular expression the test method names are checked against.", defaultValue="^test[A-Z][a-zA-Z0-9]*$")
    public String format = "^test[A-Z][a-zA-Z0-9]*$";
    private Pattern pattern = null;

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void setContext(JavaFileScannerContext context) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.format, 32);
        }
        super.setContext(context);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if (BadTestMethodNameCheck.isNotOverriden(methodTree) && UnitTestUtils.hasTestAnnotation(methodTree) && !this.pattern.matcher(methodTree.simpleName().name()).matches()) {
            this.reportIssue((Tree)methodTree.simpleName(), "Rename this method name to match the regular expression: '" + this.format + "'");
        }
    }

    private static boolean isNotOverriden(MethodTree methodTree) {
        return Boolean.FALSE.equals(methodTree.isOverriding());
    }
}

