/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.helpers;

import java.util.Set;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonarsource.analyzer.commons.collections.SetUtils;

public final class ValueBasedUtils {
    private static final Set<String> KNOWN_VALUE_BASED_CLASSES = SetUtils.immutableSetOf((Object[])new String[]{"java.time.chrono.HijrahDate", "java.time.chrono.JapaneseDate", "java.time.chrono.MinguoDate", "java.time.chrono.ThaiBuddhistDate", "java.util.Optional", "java.util.DoubleOptional", "java.util.IntOptional", "java.util.LongOptional"});

    private ValueBasedUtils() {
    }

    public static boolean isValueBased(Type type) {
        String className = ValueBasedUtils.getRootElementType(type).fullyQualifiedName();
        return (KNOWN_VALUE_BASED_CLASSES.contains(className) || ValueBasedUtils.isInJavaTimePackage(className)) && !"java.time.Clock".equals(className);
    }

    private static boolean isInJavaTimePackage(String className) {
        return className.startsWith("java.time");
    }

    private static Type getRootElementType(Type type) {
        return type.isArray() ? ValueBasedUtils.getRootElementType(((Type.ArrayType)type).elementType()) : type;
    }
}

