/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.helpers;

import org.sonar.java.annotations.VisibleForTesting;
import org.sonar.java.checks.helpers.LatinAlphabetLanguagesHelper;
import org.sonar.java.checks.helpers.ShannonEntropy;

public class RandomnessDetector {
    private static final int MIN_SECRET_LENGTH_FOR_GIVEN_ENTROPY = 25;
    private static final double ENTROPY_INCREASE_FACTOR_BY_MISSING_CHARACTER = 1.034;
    private final double minEntropyThreshold;
    private final double maxLanguageScore;
    private static final double LANGUAGE_SCORE_INCREMENT = 0.3;
    private static final double ENTROPY_SCORE_INCREMENT = 0.6;

    public RandomnessDetector(double randomnessSensibility) {
        this.minEntropyThreshold = randomnessSensibility * 0.6;
        this.maxLanguageScore = (10.0 - randomnessSensibility) * 0.3;
    }

    public boolean isRandom(String literal) {
        return this.hasEnoughEntropy(literal) && this.hasLowLanguageScore(literal);
    }

    @VisibleForTesting
    boolean hasEnoughEntropy(String literal) {
        double effectiveMinEntropyThreshold = this.minEntropyThreshold;
        if (literal.length() < 25) {
            int missingCharacterCount = 25 - literal.length();
            effectiveMinEntropyThreshold *= Math.pow(1.034, missingCharacterCount);
        }
        return ShannonEntropy.calculate(literal) >= effectiveMinEntropyThreshold;
    }

    @VisibleForTesting
    boolean hasLowLanguageScore(String literal) {
        return LatinAlphabetLanguagesHelper.humanLanguageScore(literal) < this.maxLanguageScore;
    }
}

