/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.aws;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.checks.aws.AbstractAwsMethodVisitor;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S6243")
public class AwsReusableResourcesInitializedOnceCheck
extends AbstractAwsMethodVisitor {
    private static final String MESSAGE_TEMPLATE = "Instantiate this %s outside the Lambda function.";
    private static final String MESSAGE_CLIENT = String.format("Instantiate this %s outside the Lambda function.", "client");
    private static final String MESSAGE_DATABASE_CONNECTION = String.format("Instantiate this %s outside the Lambda function.", "database connection");
    private static final String SDK_CLIENT_TYPE = "software.amazon.awssdk.core.SdkClient";
    private static final MethodMatchers CREATION_METHODS_MATCHERS = MethodMatchers.create().ofAnyType().names(new String[]{"build"}).withAnyParameters().build();
    private static final MethodMatchers CONNECTION_CREATION_MATCHERS = MethodMatchers.create().ofTypes(new String[]{"java.sql.DriverManager"}).names(new String[]{"getConnection"}).withAnyParameters().build();

    @Override
    void visitReachableMethodsFromHandleRequest(Set<MethodTree> methodTrees) {
        ResourceCreationFinder finder = new ResourceCreationFinder();
        methodTrees.forEach(m -> m.accept((TreeVisitor)finder));
        finder.getBuilderInvocations().forEach((call, msg) -> this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)call), (String)msg));
        finder.getConstructorInvocations().forEach((call, msg) -> this.reportIssue((Tree)call.identifier(), (String)msg));
    }

    private static class ResourceCreationFinder
    extends BaseTreeVisitor {
        private final Map<MethodInvocationTree, String> builderInvocations = new IdentityHashMap<MethodInvocationTree, String>();
        private final Map<NewClassTree, String> constructorInvocations = new IdentityHashMap<NewClassTree, String>();

        private ResourceCreationFinder() {
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            ResourceCreationFinder.methodCreatesResource(tree).ifPresent(msgPart -> this.builderInvocations.put(tree, (String)msgPart));
        }

        public void visitNewClass(NewClassTree tree) {
            if (tree.symbolType().isSubtypeOf(AwsReusableResourcesInitializedOnceCheck.SDK_CLIENT_TYPE)) {
                this.constructorInvocations.put(tree, MESSAGE_CLIENT);
            }
        }

        private static Optional<String> methodCreatesResource(MethodInvocationTree tree) {
            if (CREATION_METHODS_MATCHERS.matches(tree) && tree.symbolType().isSubtypeOf(AwsReusableResourcesInitializedOnceCheck.SDK_CLIENT_TYPE)) {
                return Optional.of(MESSAGE_CLIENT);
            }
            if (CONNECTION_CREATION_MATCHERS.matches(tree)) {
                return Optional.of(MESSAGE_DATABASE_CONNECTION);
            }
            return Optional.empty();
        }

        public Map<MethodInvocationTree, String> getBuilderInvocations() {
            return this.builderInvocations;
        }

        public Map<NewClassTree, String> getConstructorInvocations() {
            return this.constructorInvocations;
        }
    }
}

