/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.JavaVersionAwareVisitor;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3937")
public class UnderscoreMisplacedOnNumberCheck
extends IssuableSubscriptionVisitor
implements JavaVersionAwareVisitor {
    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava7Compatible();
    }

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.INT_LITERAL, Tree.Kind.LONG_LITERAL);
    }

    public void visitNode(Tree tree) {
        LiteralTree literalTree = (LiteralTree)tree;
        String value = literalTree.value();
        if (UnderscoreMisplacedOnNumberCheck.isNotABinaryNumber(value) && UnderscoreMisplacedOnNumberCheck.hasIrregularPattern(value)) {
            this.reportIssue((Tree)literalTree, "Review this number; its irregular pattern indicates an error.");
        }
    }

    private static boolean isNotABinaryNumber(String literalValue) {
        return !literalValue.startsWith("0b") && !literalValue.startsWith("0B");
    }

    private static boolean hasIrregularPattern(String literalValue) {
        List<String> groups = Arrays.asList(UnderscoreMisplacedOnNumberCheck.cleanup(literalValue).split("_"));
        if (groups.size() <= 1) {
            return false;
        }
        int firstGroupLength = groups.get(0).length();
        List lengths = groups.stream().skip(1L).map(String::length).distinct().collect(Collectors.toList());
        return lengths.size() != 1 || (Integer)lengths.get(0) < firstGroupLength;
    }

    private static String cleanup(String literalValue) {
        String result = literalValue.toLowerCase();
        if (result.startsWith("0b") || result.startsWith("0x")) {
            result = result.substring(2);
        }
        if (result.endsWith("l")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }
}

