/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonarsource.analyzer.commons.collections.MapBuilder;

@Rule(key="S1149")
public class SynchronizedClassUsageCheck
extends IssuableSubscriptionVisitor {
    private static final Map<String, String> REPLACEMENTS = MapBuilder.newMap().put((Object)"java.util.Vector", (Object)"\"ArrayList\" or \"LinkedList\"").put((Object)"java.util.Hashtable", (Object)"\"HashMap\"").put((Object)"java.lang.StringBuffer", (Object)"\"StringBuilder\"").put((Object)"java.util.Stack", (Object)"\"Deque\"").build();
    private final Deque<Set<String>> exclusions = new ArrayDeque<Set<String>>();
    private final Set<Tree> visited = new HashSet<Tree>();

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.CLASS, Tree.Kind.COMPILATION_UNIT, Tree.Kind.ENUM, Tree.Kind.INTERFACE, Tree.Kind.ANNOTATION_TYPE);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.COMPILATION_UNIT})) {
            this.visited.clear();
            return;
        }
        ExclusionsVisitor exclusionsVisitor = new ExclusionsVisitor();
        tree.accept((TreeVisitor)exclusionsVisitor);
        Set<String> currentClassExclusions = exclusionsVisitor.exclusions;
        if (!this.exclusions.isEmpty()) {
            currentClassExclusions.addAll((Collection<String>)this.exclusions.peek());
        }
        this.exclusions.push(currentClassExclusions);
        tree.accept((TreeVisitor)new DeprecatedTypeVisitor());
    }

    public void leaveNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.COMPILATION_UNIT})) {
            return;
        }
        this.exclusions.pop();
    }

    private static class ExclusionsVisitor
    extends BaseTreeVisitor {
        Set<String> exclusions = new HashSet<String>();

        private ExclusionsVisitor() {
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            String fqn;
            if (tree.methodSymbol().isMethodSymbol() && tree.methodSymbol().declaration() == null && ExclusionsVisitor.isMethodFromJavaPackage(fqn = tree.methodSymbol().owner().type().fullyQualifiedName())) {
                Symbol.MethodSymbol methodSymbol = tree.methodSymbol();
                ArrayList<Type> types = new ArrayList<Type>(methodSymbol.parameterTypes());
                Symbol.TypeSymbol returnType = methodSymbol.returnType();
                if (returnType != null) {
                    types.add(returnType.type());
                }
                types.forEach(t -> this.exclusions.addAll(REPLACEMENTS.keySet().stream().filter(arg_0 -> ((Type)t).isSubtypeOf(arg_0)).collect(Collectors.toSet())));
            }
            super.visitMethodInvocation(tree);
        }

        private static boolean isMethodFromJavaPackage(String fqn) {
            return fqn.startsWith("java") && !REPLACEMENTS.containsKey(fqn);
        }
    }

    private class DeprecatedTypeVisitor
    extends BaseTreeVisitor {
        private Deque<Set<String>> overridingMethodTypes = new ArrayDeque<Set<String>>();

        private DeprecatedTypeVisitor() {
        }

        public void visitClass(ClassTree tree) {
            TypeTree superClass = tree.superClass();
            if (superClass != null) {
                this.reportIssueOnDeprecatedType((Tree)ExpressionsHelper.reportOnClassTree(tree), superClass.symbolType());
            }
            this.scan(tree.members());
        }

        public void visitMethod(MethodTree tree) {
            TypeTree returnTypeTree = tree.returnType();
            boolean isConstructor = tree.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR});
            if (this.isOverriding(tree) && !isConstructor) {
                this.overridingMethodTypes.push(this.collectOverridingMethodExclusions(tree, returnTypeTree));
            } else {
                this.overridingMethodTypes.push(Collections.emptySet());
                if (!isConstructor) {
                    this.reportIssueOnDeprecatedType((Tree)returnTypeTree, returnTypeTree.symbolType());
                }
                this.scan(tree.parameters());
            }
            this.scan((Tree)tree.block());
            this.overridingMethodTypes.pop();
        }

        private Set<String> collectOverridingMethodExclusions(MethodTree methodTree, TypeTree returnType) {
            HashSet<String> methodTypes = new HashSet<String>();
            methodTypes.add(returnType.symbolType().fullyQualifiedName());
            methodTree.parameters().stream().map(param -> param.type().symbolType().fullyQualifiedName()).forEach(methodTypes::add);
            return methodTypes;
        }

        private boolean isOverriding(MethodTree tree) {
            return Boolean.TRUE.equals(tree.isOverriding());
        }

        public void visitVariable(VariableTree tree) {
            ExpressionTree initializer = tree.initializer();
            if (!this.reportIssueOnDeprecatedType((Tree)tree.type(), tree.symbol().type()) && initializer != null && !initializer.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                this.reportIssueOnDeprecatedType((Tree)initializer, initializer.symbolType());
            }
        }

        public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
            this.scan(lambdaExpressionTree.body());
        }

        private boolean reportIssueOnDeprecatedType(Tree tree, Type type) {
            if (SynchronizedClassUsageCheck.this.visited.contains(tree) || this.isAllowedByOverridingSignature(type)) {
                return false;
            }
            SynchronizedClassUsageCheck.this.visited.add(tree);
            if (this.isDeprecatedType(type)) {
                SynchronizedClassUsageCheck.this.reportIssue(tree, "Replace the synchronized class \"" + type.name() + "\" by an unsynchronized one such as " + REPLACEMENTS.get(type.fullyQualifiedName()) + ".");
                return true;
            }
            return false;
        }

        private boolean isAllowedByOverridingSignature(Type type) {
            return !this.overridingMethodTypes.isEmpty() && this.overridingMethodTypes.peek().contains(type.fullyQualifiedName());
        }

        private boolean isDeprecatedType(Type symbolType) {
            if (symbolType.isClass()) {
                for (String deprecatedType : REPLACEMENTS.keySet()) {
                    if (!symbolType.is(deprecatedType)) continue;
                    return !SynchronizedClassUsageCheck.this.exclusions.peek().contains(deprecatedType);
                }
            }
            return false;
        }
    }
}

