/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.SynchronizedStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2885")
public class StaticMultithreadedUnsafeFieldsCheck
extends IssuableSubscriptionVisitor {
    private static final String JAVA_TEXT_SIMPLE_DATE_FORMAT = "java.text.SimpleDateFormat";
    private static final String[] FORBIDDEN_TYPES = new String[]{"java.text.SimpleDateFormat", "java.util.Calendar", "javax.xml.xpath.XPath", "javax.xml.validation.SchemaFactory"};
    private static final MethodMatchers GET_DATE_INSTANCE = MethodMatchers.create().ofTypes(new String[]{"java.text.DateFormat"}).names(new String[]{"getDateInstance"}).addWithoutParametersMatcher().build();

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.VARIABLE);
    }

    public void visitNode(Tree tree) {
        VariableTree variableTree = (VariableTree)tree;
        Type type = variableTree.type().symbolType();
        if (ModifiersUtils.hasModifier((ModifiersTree)variableTree.modifiers(), (Modifier)Modifier.STATIC) && StaticMultithreadedUnsafeFieldsCheck.isForbidden(variableTree)) {
            if (type.isSubtypeOf(JAVA_TEXT_SIMPLE_DATE_FORMAT) && StaticMultithreadedUnsafeFieldsCheck.onlySynchronizedUsages((Symbol.VariableSymbol)variableTree.symbol())) {
                return;
            }
            IdentifierTree identifierTree = variableTree.simpleName();
            this.reportIssue((Tree)identifierTree, String.format("Make \"%s\" an instance variable.", identifierTree.name()));
        }
    }

    private static boolean isForbidden(VariableTree variableTree) {
        if (StaticMultithreadedUnsafeFieldsCheck.isForbiddenType(variableTree.type().symbolType())) {
            return true;
        }
        ExpressionTree initializer = variableTree.initializer();
        if (initializer == null || initializer.is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL})) {
            return false;
        }
        return StaticMultithreadedUnsafeFieldsCheck.isForbiddenType(initializer.symbolType()) || initializer.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && GET_DATE_INSTANCE.matches((MethodInvocationTree)initializer);
    }

    private static boolean isForbiddenType(Type type) {
        for (String name : FORBIDDEN_TYPES) {
            if (!type.isSubtypeOf(name)) continue;
            return true;
        }
        return false;
    }

    private static boolean onlySynchronizedUsages(Symbol.VariableSymbol variable) {
        List usages = variable.usages();
        if (usages.isEmpty()) {
            return false;
        }
        for (IdentifierTree usage : usages) {
            SynchronizedStatementTree synchronizedStatementTree = StaticMultithreadedUnsafeFieldsCheck.getParentSynchronizedStatement(usage);
            if (synchronizedStatementTree == null) {
                return false;
            }
            ExpressionTree expression = synchronizedStatementTree.expression();
            if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && variable.equals((Object)((IdentifierTree)expression).symbol())) continue;
            return false;
        }
        return true;
    }

    @CheckForNull
    private static SynchronizedStatementTree getParentSynchronizedStatement(IdentifierTree usage) {
        Tree parent;
        for (parent = usage.parent(); parent != null && !parent.is(new Tree.Kind[]{Tree.Kind.SYNCHRONIZED_STATEMENT}); parent = parent.parent()) {
        }
        if (parent == null) {
            return null;
        }
        return (SynchronizedStatementTree)parent;
    }
}

