/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.SynchronizedStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S3010")
public class StaticFieldUpdateInConstructorCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CONSTRUCTOR);
    }

    public void visitNode(Tree tree) {
        MethodTree constructor = (MethodTree)tree;
        Symbol.TypeSymbol owner = constructor.symbol().enclosingClass();
        Set<Symbol> staticFields = owner.memberSymbols().stream().filter(Symbol::isVariableSymbol).filter(Symbol::isStatic).collect(Collectors.toSet());
        StaticFieldUpdateVisitor visitor = new StaticFieldUpdateVisitor(staticFields);
        constructor.block().accept((TreeVisitor)visitor);
        visitor.assignedStaticFields().forEach(identifierTree -> {
            Symbol staticField = identifierTree.symbol();
            this.reportIssue((Tree)identifierTree, "Remove this assignment of \"" + staticField.name() + "\".", Collections.singletonList(new JavaFileScannerContext.Location("Static field declaration.", staticField.declaration())), null);
        });
    }

    private static class StaticFieldUpdateVisitor
    extends BaseTreeVisitor {
        private final Set<Symbol> staticFields;
        private final List<IdentifierTree> assignedStaticFields;

        StaticFieldUpdateVisitor(Set<Symbol> staticFields) {
            this.staticFields = staticFields;
            this.assignedStaticFields = new ArrayList<IdentifierTree>();
        }

        Stream<IdentifierTree> assignedStaticFields() {
            return this.assignedStaticFields.stream();
        }

        public void visitSynchronizedStatement(SynchronizedStatementTree tree) {
        }

        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            this.checkExpression(tree.variable());
            super.visitAssignmentExpression(tree);
        }

        private void checkExpression(ExpressionTree expressionTree) {
            IdentifierTree variable = StaticFieldUpdateVisitor.getVariable(expressionTree);
            if (variable != null && this.staticFields.contains(variable.symbol())) {
                this.assignedStaticFields.add(variable);
            }
        }

        @CheckForNull
        private static IdentifierTree getVariable(ExpressionTree expressionTree) {
            ExpressionTree variable = ExpressionUtils.skipParentheses((ExpressionTree)expressionTree);
            if (variable.is(new Tree.Kind[]{Tree.Kind.ARRAY_ACCESS_EXPRESSION})) {
                return StaticFieldUpdateVisitor.getVariable(((ArrayAccessExpressionTree)variable).expression());
            }
            if (variable.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                return StaticFieldUpdateVisitor.getVariable((ExpressionTree)((MemberSelectExpressionTree)variable).identifier());
            }
            if (variable.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                return (IdentifierTree)variable;
            }
            return null;
        }
    }
}

