/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.JProblem;
import org.sonar.java.model.JWarning;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.SyntacticEquivalence;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1656")
public class SelfAssignementCheck
extends IssuableSubscriptionVisitor {
    private static final String ISSUE_MESSAGE = "Remove or correct this useless self-assignment.";
    private final Set<JWarning> warnings = new HashSet<JWarning>();

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.COMPILATION_UNIT, Tree.Kind.ASSIGNMENT);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.COMPILATION_UNIT})) {
            this.warnings.clear();
            this.warnings.addAll(((JavaTree.CompilationUnitTreeImpl)tree).warnings(JProblem.Type.ASSIGNMENT_HAS_NO_EFFECT));
            return;
        }
        AssignmentExpressionTree node = (AssignmentExpressionTree)tree;
        if (SyntacticEquivalence.areEquivalent((Tree)node.expression(), (Tree)node.variable())) {
            if (node.parent().is(new Tree.Kind[]{Tree.Kind.VARIABLE}) || node.parent().is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) {
                QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)SelfAssignementCheck.reportTree(node)).withMessage(ISSUE_MESSAGE).report();
            } else {
                QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)SelfAssignementCheck.reportTree(node)).withMessage(ISSUE_MESSAGE).withQuickFix(() -> SelfAssignementCheck.getQuickFix(node)).report();
            }
            this.updateWarnings(node);
        }
    }

    private static JavaQuickFix getQuickFix(AssignmentExpressionTree tree) {
        ClassTree classParent = (ClassTree)ExpressionUtils.getParentOfType((Tree)tree, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.CLASS, Tree.Kind.INTERFACE});
        MethodTree methodParent = (MethodTree)ExpressionUtils.getParentOfType((Tree)tree, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR});
        String name = SelfAssignementCheck.getName(tree.variable());
        boolean isMethodParameter = methodParent.parameters().stream().map(p -> p.simpleName().name()).anyMatch(p -> p.equals(name));
        if (isMethodParameter) {
            List memberNames = classParent.members().stream().filter(m -> m.is(new Tree.Kind[]{Tree.Kind.VARIABLE})).map(VariableTree.class::cast).map(m -> m.simpleName().name()).collect(Collectors.toList());
            if (memberNames.contains(name)) {
                return JavaQuickFix.newQuickFix((String)"Disambiguate this self-assignment").addTextEdit(new JavaTextEdit[]{JavaTextEdit.insertBeforeTree((Tree)tree.variable(), (String)"this.")}).build();
            }
        }
        return JavaQuickFix.newQuickFix((String)"Remove this useless self-assignment").addTextEdit(new JavaTextEdit[]{JavaTextEdit.removeTextSpan((AnalyzerMessage.TextSpan)AnalyzerMessage.textSpanBetween((Tree)tree, (boolean)true, (Tree)QuickFixHelper.nextToken((Tree)tree), (boolean)true))}).build();
    }

    private static String getName(ExpressionTree variable) {
        if (variable.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return ((IdentifierTree)variable).name();
        }
        if (variable.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            return ((MemberSelectExpressionTree)variable).identifier().name();
        }
        return "";
    }

    private static SyntaxToken reportTree(AssignmentExpressionTree node) {
        return node.operatorToken();
    }

    public void leaveNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.COMPILATION_UNIT})) {
            this.warnings.forEach(warning -> {
                AssignmentExpressionTree node = (AssignmentExpressionTree)warning.syntaxTree();
                if (node.parent().is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
                    return;
                }
                QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)SelfAssignementCheck.reportTree(node)).withMessage(ISSUE_MESSAGE).withQuickFix(() -> SelfAssignementCheck.getQuickFix(node)).report();
            });
        }
    }

    private void updateWarnings(AssignmentExpressionTree tree) {
        this.warnings.removeIf(warning -> tree.equals((Object)warning.syntaxTree()));
    }
}

