/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.java.model.JUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeArguments;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.WildcardTree;

@Rule(key="S6411")
public class MapKeyNotComparableCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.PARAMETERIZED_TYPE);
    }

    public void visitNode(Tree tree) {
        ParameterizedTypeTree typeTree = (ParameterizedTypeTree)tree;
        Type type = typeTree.symbolType();
        if (type.isSubtypeOf("java.util.Map")) {
            MapKeyNotComparableCheck.getMapKeyTree(typeTree).ifPresent(mapKeyTree -> {
                if (!(MapKeyNotComparableCheck.isGenericOrWildCard(mapKeyTree) || MapKeyNotComparableCheck.implementsComparable(mapKeyTree.symbolType()) || JUtils.hasUnknownTypeInHierarchy((Symbol.TypeSymbol)mapKeyTree.symbolType().symbol()))) {
                    this.reportIssue((Tree)mapKeyTree, "The key type should implement Comparable.");
                }
            });
        }
    }

    private static boolean isGenericOrWildCard(TypeTree tree) {
        return JUtils.isTypeVar((Type)tree.symbolType()) || tree instanceof WildcardTree;
    }

    private static Optional<TypeTree> getMapKeyTree(ParameterizedTypeTree typeTree) {
        TypeArguments typeArgs = typeTree.typeArguments();
        if (typeArgs.size() == 2) {
            TypeTree mapKeyTree = (TypeTree)typeArgs.get(0);
            return Optional.of(mapKeyTree);
        }
        return Optional.empty();
    }

    private static boolean implementsComparable(Type mapKeyType) {
        return mapKeyType.isSubtypeOf("java.lang.Comparable");
    }
}

