/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ReassignmentFinder;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2692")
public class IndexOfWithPositiveNumberCheck
extends IssuableSubscriptionVisitor {
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final String INDEX_OF = "indexOf";
    private static final MethodMatchers CHECKED_METHODS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"java.lang.String"}).names(new String[]{"indexOf"}).addParametersMatcher(new String[]{"int"}).addParametersMatcher(new String[]{"java.lang.String"}).build(), MethodMatchers.create().ofSubTypes(new String[]{"java.util.List"}).names(new String[]{"indexOf"}).addParametersMatcher(new String[]{"java.lang.Object"}).build()});

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.GREATER_THAN, Tree.Kind.LESS_THAN);
    }

    public void visitNode(Tree tree) {
        BinaryExpressionTree binaryTree = (BinaryExpressionTree)tree;
        if (tree.is(new Tree.Kind[]{Tree.Kind.GREATER_THAN})) {
            this.checkForIssue(tree, binaryTree.leftOperand(), LiteralUtils.longLiteralValue((ExpressionTree)IndexOfWithPositiveNumberCheck.retrieveClosestAssignmentIfAny(binaryTree.rightOperand())));
        } else {
            this.checkForIssue(tree, binaryTree.rightOperand(), LiteralUtils.longLiteralValue((ExpressionTree)IndexOfWithPositiveNumberCheck.retrieveClosestAssignmentIfAny(binaryTree.leftOperand())));
        }
    }

    private static ExpressionTree retrieveClosestAssignmentIfAny(ExpressionTree expression) {
        IdentifierTree identifier;
        ExpressionTree reassignmentOrDeclaration;
        if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && (reassignmentOrDeclaration = ReassignmentFinder.getClosestReassignmentOrDeclarationExpression((Tree)expression, (identifier = (IdentifierTree)expression).symbol())) != null) {
            return reassignmentOrDeclaration;
        }
        return expression;
    }

    private void checkForIssue(Tree tree, ExpressionTree operand, @Nullable Long constant) {
        if (constant != null && constant == 0L && IndexOfWithPositiveNumberCheck.isIndexOfOnArrayOrString((Tree)operand)) {
            this.reportIssue(tree, "0 is a valid index, but is ignored by this check.");
        }
    }

    private static boolean isIndexOfOnArrayOrString(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && CHECKED_METHODS.matches((MethodInvocationTree)tree);
    }
}

