/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.SyntacticEquivalence;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1244")
public class FloatEqualityCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers EQUALS_MATCHER = MethodMatchers.create().ofTypes(new String[]{"java.lang.Double", "java.lang.Float"}).names(new String[]{"equals"}).addParametersMatcher(new String[]{"java.lang.Object"}).build();

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO, Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR, Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodInvocationTree mit = (MethodInvocationTree)tree;
            if (EQUALS_MATCHER.matches(mit)) {
                this.reportIssue((Tree)mit.methodSelect(), "Equality tests should not be made with floating point values.");
            }
            return;
        }
        BinaryExpressionTree binaryExpressionTree = (BinaryExpressionTree)tree;
        if (binaryExpressionTree.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR}) && FloatEqualityCheck.isIndirectEquality(binaryExpressionTree)) {
            binaryExpressionTree = (BinaryExpressionTree)binaryExpressionTree.leftOperand();
        }
        if ((FloatEqualityCheck.hasFloatingType(binaryExpressionTree.leftOperand()) || FloatEqualityCheck.hasFloatingType(binaryExpressionTree.rightOperand())) && !FloatEqualityCheck.isNanTest(binaryExpressionTree)) {
            this.reportIssue((Tree)binaryExpressionTree.operatorToken(), "Equality tests should not be made with floating point values.");
        }
    }

    private static boolean isIndirectEquality(BinaryExpressionTree binaryExpressionTree) {
        return FloatEqualityCheck.isIndirectEquality(binaryExpressionTree, Tree.Kind.CONDITIONAL_AND, Tree.Kind.GREATER_THAN_OR_EQUAL_TO, Tree.Kind.LESS_THAN_OR_EQUAL_TO) || FloatEqualityCheck.isIndirectEquality(binaryExpressionTree, Tree.Kind.CONDITIONAL_OR, Tree.Kind.GREATER_THAN, Tree.Kind.LESS_THAN);
    }

    private static boolean isIndirectEquality(BinaryExpressionTree binaryExpressionTree, Tree.Kind indirectOperator, Tree.Kind comparator1, Tree.Kind comparator2) {
        if (binaryExpressionTree.is(new Tree.Kind[]{indirectOperator}) && binaryExpressionTree.leftOperand().is(new Tree.Kind[]{comparator1, comparator2})) {
            BinaryExpressionTree leftOp = (BinaryExpressionTree)binaryExpressionTree.leftOperand();
            if (binaryExpressionTree.rightOperand().is(new Tree.Kind[]{comparator1, comparator2})) {
                BinaryExpressionTree rightOp = (BinaryExpressionTree)binaryExpressionTree.rightOperand();
                if (leftOp.kind().equals((Object)rightOp.kind())) {
                    return SyntacticEquivalence.areEquivalent((Tree)leftOp.leftOperand(), (Tree)rightOp.rightOperand()) && SyntacticEquivalence.areEquivalent((Tree)leftOp.rightOperand(), (Tree)rightOp.leftOperand());
                }
                return SyntacticEquivalence.areEquivalent((Tree)leftOp.leftOperand(), (Tree)rightOp.leftOperand()) && SyntacticEquivalence.areEquivalent((Tree)leftOp.rightOperand(), (Tree)rightOp.rightOperand());
            }
        }
        return false;
    }

    private static boolean isNanTest(BinaryExpressionTree binaryExpressionTree) {
        return SyntacticEquivalence.areEquivalent((Tree)binaryExpressionTree.leftOperand(), (Tree)binaryExpressionTree.rightOperand());
    }

    private static boolean hasFloatingType(ExpressionTree expressionTree) {
        return expressionTree.symbolType().isPrimitive(Type.Primitives.FLOAT) || expressionTree.symbolType().isPrimitive(Type.Primitives.DOUBLE);
    }
}

