/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.sonar.check.Rule;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2039")
public class FieldModifierCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.CLASS, Tree.Kind.ENUM);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        classTree.members().stream().filter(FieldModifierCheck::isConsentWithCheck).forEach(member -> {
            VariableTree variableTree = (VariableTree)member;
            if (!FieldModifierCheck.hasModifierComment(variableTree)) {
                IdentifierTree simpleName = variableTree.simpleName();
                this.reportIssue((Tree)simpleName, "Explicitly declare the visibility for \"" + simpleName.name() + "\".");
            }
        });
    }

    private static boolean hasModifierComment(VariableTree variableTree) {
        for (SyntaxTrivia syntaxTrivia : variableTree.type().lastToken().trivias()) {
            if (!syntaxTrivia.comment().toLowerCase(Locale.ROOT).contains("modifier")) continue;
            return true;
        }
        return false;
    }

    private static boolean isConsentWithCheck(Tree member) {
        return member.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) && FieldModifierCheck.hasNoVisibilityModifier((VariableTree)member) && !FieldModifierCheck.isVisibleForTesting((VariableTree)member);
    }

    private static boolean hasNoVisibilityModifier(VariableTree variableTree) {
        return ModifiersUtils.hasNoneOf((ModifiersTree)variableTree.modifiers(), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.PRIVATE, Modifier.PROTECTED});
    }

    private static boolean isVisibleForTesting(VariableTree variableTree) {
        return variableTree.modifiers().annotations().stream().anyMatch(annotation -> "VisibleForTesting".equals(annotation.annotationType().lastToken().text()));
    }
}

