/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.LiteralUtils;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.collections.ListUtils;

@Rule(key="S1155")
public class CollectionIsEmptyCheck
extends IssuableSubscriptionVisitor {
    private static final String JAVA_UTIL_COLLECTION = "java.util.Collection";
    private static final MethodMatchers SIZE_METHOD = MethodMatchers.create().ofSubTypes(new String[]{"java.util.Collection"}).names(new String[]{"size"}).addWithoutParametersMatcher().build();
    private static final Tree.Kind[] TARGETED_BINARY_OPERATOR_TREES = new Tree.Kind[]{Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO, Tree.Kind.LESS_THAN, Tree.Kind.LESS_THAN_OR_EQUAL_TO, Tree.Kind.GREATER_THAN, Tree.Kind.GREATER_THAN_OR_EQUAL_TO};
    private static final Tree.Kind[] CLASS_TREES = new Tree.Kind[]{Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.INTERFACE, Tree.Kind.RECORD, Tree.Kind.ANNOTATION_TYPE};
    private static final Deque<Boolean> IS_COLLECTION_ENCLOSING_TYPES_STACK = new LinkedList<Boolean>();

    public List<Tree.Kind> nodesToVisit() {
        return ListUtils.concat((List[])new List[]{Arrays.asList(CLASS_TREES), Arrays.asList(TARGETED_BINARY_OPERATOR_TREES)});
    }

    public void leaveFile(JavaFileScannerContext context) {
        IS_COLLECTION_ENCLOSING_TYPES_STACK.clear();
    }

    public void visitNode(Tree tree) {
        if (tree.is(CLASS_TREES)) {
            CollectionIsEmptyCheck.handleClassTree((ClassTree)tree);
        } else {
            this.handleBinaryExpressionTree((BinaryExpressionTree)tree);
        }
    }

    private static void handleClassTree(ClassTree tree) {
        Symbol.TypeSymbol symbol = tree.symbol();
        boolean isCollection = symbol.type().isSubtypeOf(JAVA_UTIL_COLLECTION);
        if (CollectionIsEmptyCheck.isInnerClassOfCollection(symbol)) {
            isCollection = true;
        }
        IS_COLLECTION_ENCLOSING_TYPES_STACK.push(isCollection);
    }

    private static boolean isInnerClassOfCollection(Symbol.TypeSymbol symbol) {
        return Boolean.TRUE.equals(IS_COLLECTION_ENCLOSING_TYPES_STACK.peek()) && !symbol.isStatic();
    }

    private void handleBinaryExpressionTree(BinaryExpressionTree tree) {
        if (CollectionIsEmptyCheck.isInCollectionType()) {
            return;
        }
        CollectionIsEmptyCheck.getCallToSizeInvocation(tree).ifPresent(callToSizeInvocation -> CollectionIsEmptyCheck.getEmptyComparisonType(tree).ifPresent(comparisonType -> QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)tree).withMessage("Use isEmpty() to check whether the collection is empty or not.").withQuickFix(() -> CollectionIsEmptyCheck.getQuickFix(tree, callToSizeInvocation, comparisonType)).report()));
    }

    private static boolean isInCollectionType() {
        return Boolean.TRUE.equals(IS_COLLECTION_ENCLOSING_TYPES_STACK.peek());
    }

    public void leaveNode(Tree tree) {
        if (tree.is(CLASS_TREES)) {
            IS_COLLECTION_ENCLOSING_TYPES_STACK.pop();
        }
    }

    private static JavaQuickFix getQuickFix(BinaryExpressionTree tree, MethodInvocationTree callToSizeInvocation, EmptyComparisonType emptyComparisonType) {
        String replacement;
        IdentifierTree sizeCallIdentifier = ExpressionUtils.methodName((MethodInvocationTree)callToSizeInvocation);
        JavaQuickFix.Builder builder = JavaQuickFix.newQuickFix((String)"Use \"isEmpty()\"");
        AnalyzerMessage.TextSpan textSpan = AnalyzerMessage.textSpanBetween((Tree)tree.firstToken(), (boolean)true, (Tree)callToSizeInvocation, (boolean)false);
        String string = replacement = emptyComparisonType == EmptyComparisonType.EMPTY ? "" : "!";
        if (!textSpan.isEmpty() || !replacement.isEmpty()) {
            builder.addTextEdit(new JavaTextEdit[]{JavaTextEdit.replaceTextSpan((AnalyzerMessage.TextSpan)textSpan, (String)replacement)});
        }
        builder.addTextEdit(new JavaTextEdit[]{JavaTextEdit.replaceTextSpan((AnalyzerMessage.TextSpan)AnalyzerMessage.textSpanBetween((Tree)sizeCallIdentifier, (boolean)true, (Tree)tree.lastToken(), (boolean)true), (String)"isEmpty()")});
        return builder.build();
    }

    private static Optional<MethodInvocationTree> getCallToSizeInvocation(BinaryExpressionTree tree) {
        return CollectionIsEmptyCheck.getCallToSizeInvocation(tree.leftOperand()).or(() -> CollectionIsEmptyCheck.getCallToSizeInvocation(tree.rightOperand()));
    }

    private static Optional<MethodInvocationTree> getCallToSizeInvocation(ExpressionTree tree) {
        MethodInvocationTree invocationTree;
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && SIZE_METHOD.matches(invocationTree = (MethodInvocationTree)tree)) {
            return Optional.of(invocationTree);
        }
        return Optional.empty();
    }

    private static Optional<EmptyComparisonType> getEmptyComparisonType(BinaryExpressionTree tree) {
        boolean anyZero;
        boolean leftIsZero = LiteralUtils.isZero((ExpressionTree)tree.leftOperand());
        boolean leftIsOne = LiteralUtils.isOne((ExpressionTree)tree.leftOperand());
        boolean rightIsZero = LiteralUtils.isZero((ExpressionTree)tree.rightOperand());
        boolean rightIsOne = LiteralUtils.isOne((ExpressionTree)tree.rightOperand());
        boolean bl = anyZero = leftIsZero || rightIsZero;
        if (CollectionIsEmptyCheck.isEmptyComparison(tree, leftIsZero, leftIsOne, rightIsZero, rightIsOne, anyZero)) {
            return Optional.of(EmptyComparisonType.EMPTY);
        }
        if (CollectionIsEmptyCheck.isNotEmptyComparison(tree, leftIsZero, leftIsOne, rightIsZero, rightIsOne, anyZero)) {
            return Optional.of(EmptyComparisonType.NOT_EMPTY);
        }
        return Optional.empty();
    }

    private static boolean isEmptyComparison(BinaryExpressionTree tree, boolean leftIsZero, boolean leftIsOne, boolean rightIsZero, boolean rightIsOne, boolean anyZero) {
        return tree.is(new Tree.Kind[]{Tree.Kind.EQUAL_TO}) && anyZero || tree.is(new Tree.Kind[]{Tree.Kind.LESS_THAN}) && rightIsOne || tree.is(new Tree.Kind[]{Tree.Kind.LESS_THAN_OR_EQUAL_TO}) && rightIsZero || tree.is(new Tree.Kind[]{Tree.Kind.GREATER_THAN}) && leftIsOne || tree.is(new Tree.Kind[]{Tree.Kind.GREATER_THAN_OR_EQUAL_TO}) && leftIsZero;
    }

    private static boolean isNotEmptyComparison(BinaryExpressionTree tree, boolean leftIsZero, boolean leftIsOne, boolean rightIsZero, boolean rightIsOne, boolean anyZero) {
        return tree.is(new Tree.Kind[]{Tree.Kind.NOT_EQUAL_TO}) && anyZero || tree.is(new Tree.Kind[]{Tree.Kind.GREATER_THAN}) && rightIsZero || tree.is(new Tree.Kind[]{Tree.Kind.GREATER_THAN_OR_EQUAL_TO}) && rightIsOne || tree.is(new Tree.Kind[]{Tree.Kind.LESS_THAN}) && leftIsZero || tree.is(new Tree.Kind[]{Tree.Kind.LESS_THAN_OR_EQUAL_TO}) && leftIsOne;
    }

    private static enum EmptyComparisonType {
        EMPTY,
        NOT_EMPTY;

    }
}

