/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonarsource.analyzer.commons.collections.MapBuilder;

@Rule(key="S1319")
public class CollectionImplementationReferencedCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final String DEQUE = "java.util.Deque";
    private static final String LIST = "java.util.List";
    private static final String MAP = "java.util.Map";
    private static final String CONCURRENT_MAP = "java.util.concurrent.ConcurrentMap";
    private static final String QUEUE = "java.util.Queue";
    private static final String SET = "java.util.Set";
    private static final String SORTED_MAP = "java.util.SortedMap";
    private static final String SORTED_SET = "java.util.SortedSet";
    private static final Map<String, String> MAPPING = MapBuilder.newMap().put((Object)"java.util.ArrayDeque", (Object)"java.util.Deque").put((Object)"java.util.concurrent.ConcurrentLinkedDeque", (Object)"java.util.Deque").put((Object)"java.util.AbstractList", (Object)"java.util.List").put((Object)"java.util.AbstractSequentialList", (Object)"java.util.List").put((Object)"java.util.ArrayList", (Object)"java.util.List").put((Object)"java.util.LinkedList", (Object)"java.util.List").put((Object)"java.util.concurrent.CopyOnWriteArrayList", (Object)"java.util.List").put((Object)"java.util.AbstractMap", (Object)"java.util.Map").put((Object)"java.util.EnumMap", (Object)"java.util.Map").put((Object)"java.util.HashMap", (Object)"java.util.Map").put((Object)"java.util.Hashtable", (Object)"java.util.Map").put((Object)"java.util.IdentityHashMap", (Object)"java.util.Map").put((Object)"java.util.LinkedHashMap", (Object)"java.util.Map").put((Object)"java.util.WeakHashMap", (Object)"java.util.Map").put((Object)"java.util.concurrent.ConcurrentHashMap", (Object)"java.util.concurrent.ConcurrentMap").put((Object)"java.util.concurrent.ConcurrentSkipListMap", (Object)"java.util.concurrent.ConcurrentMap").put((Object)"java.util.AbstractQueue", (Object)"java.util.Queue").put((Object)"java.util.concurrent.ConcurrentLinkedQueue", (Object)"java.util.Queue").put((Object)"java.util.concurrent.SynchronousQueue", (Object)"java.util.Queue").put((Object)"java.util.AbstractSet", (Object)"java.util.Set").put((Object)"java.util.concurrent.CopyOnWriteArraySet", (Object)"java.util.Set").put((Object)"java.util.EnumSet", (Object)"java.util.Set").put((Object)"java.util.HashSet", (Object)"java.util.Set").put((Object)"java.util.LinkedHashSet", (Object)"java.util.Set").put((Object)"java.util.TreeMap", (Object)"java.util.SortedMap").put((Object)"java.util.TreeSet", (Object)"java.util.SortedSet").build();
    private JavaFileScannerContext context;
    private QuickFixHelper.ImportSupplier importSupplier;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.importSupplier = null;
        this.scan((Tree)context.getTree());
    }

    public void visitVariable(VariableTree tree) {
        super.visitVariable(tree);
        if (CollectionImplementationReferencedCheck.isPublic(tree.modifiers())) {
            this.checkIfAllowed(tree.type(), String.format("The type of \"%s\"", tree.simpleName()));
        }
    }

    public void visitMethod(MethodTree tree) {
        super.visitMethod(tree);
        if (CollectionImplementationReferencedCheck.isPublic(tree.modifiers()) && Boolean.FALSE.equals(tree.isOverriding())) {
            this.checkIfAllowed(tree.returnType(), "The return type of this method");
            for (VariableTree variableTree : tree.parameters()) {
                this.checkIfAllowed(variableTree.type(), String.format("The type of \"%s\"", variableTree.simpleName()));
            }
        }
    }

    private void checkIfAllowed(@Nullable TypeTree tree, String messagePrefix) {
        if (tree == null) {
            return;
        }
        String usedCollection = tree.symbolType().erasure().fullyQualifiedName();
        if (!MAPPING.containsKey(usedCollection)) {
            return;
        }
        TypeTree reportTree = tree.is(new Tree.Kind[]{Tree.Kind.PARAMETERIZED_TYPE}) ? ((ParameterizedTypeTree)tree).type() : tree;
        String targetCollection = MAPPING.get(usedCollection);
        String usedCollectionSimpleName = CollectionImplementationReferencedCheck.toSimpleName(usedCollection);
        QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)reportTree).withMessage("%s should be an interface such as \"%s\" rather than the implementation \"%s\".", new Object[]{messagePrefix, CollectionImplementationReferencedCheck.toSimpleName(targetCollection), usedCollectionSimpleName}).withQuickFix(() -> this.quickFix(reportTree, usedCollectionSimpleName, targetCollection)).report();
    }

    private JavaQuickFix quickFix(TypeTree typeTree, String usedCollection, String targetedCollection) {
        String targetedCollectionSimpleName = CollectionImplementationReferencedCheck.toSimpleName(targetedCollection);
        ArrayList<JavaTextEdit> edits = new ArrayList<JavaTextEdit>();
        edits.add(JavaTextEdit.replaceTree((Tree)typeTree, (String)targetedCollectionSimpleName));
        this.getImportSupplier().newImportEdit(targetedCollection).ifPresent(edits::add);
        return JavaQuickFix.newQuickFix((String)"Replace \"%s\" by \"%s\"", (Object[])new Object[]{usedCollection, targetedCollectionSimpleName}).addTextEdits(edits).build();
    }

    private QuickFixHelper.ImportSupplier getImportSupplier() {
        if (this.importSupplier == null) {
            this.importSupplier = QuickFixHelper.newImportSupplier(this.context);
        }
        return this.importSupplier;
    }

    private static String toSimpleName(String fullyQualifiedName) {
        return fullyQualifiedName.substring(fullyQualifiedName.lastIndexOf(46) + 1);
    }

    private static boolean isPublic(ModifiersTree modifiers) {
        return ModifiersUtils.hasModifier((ModifiersTree)modifiers, (Modifier)Modifier.PUBLIC);
    }
}

