/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport.reactor;

import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.simpleframework.transport.reactor.ActionSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ActionSelector {
    private final Selector selector = Selector.open();

    public int select(long timeout) throws IOException {
        return this.selector.select(timeout);
    }

    public ActionSet register(SelectableChannel channel, int interest) throws IOException {
        SelectionKey key = channel.register(this.selector, interest);
        Object value = key.attachment();
        if (value == null) {
            value = new ActionSet(key);
            key.attach(value);
        }
        return (ActionSet)value;
    }

    public List<ActionSet> registeredSets() {
        Set<SelectionKey> keys = this.selector.keys();
        Iterator<SelectionKey> ready = keys.iterator();
        return this.registeredSets(ready);
    }

    private List<ActionSet> registeredSets(Iterator<SelectionKey> keys) {
        LinkedList<ActionSet> sets = new LinkedList<ActionSet>();
        while (keys.hasNext()) {
            SelectionKey key = keys.next();
            ActionSet actions = (ActionSet)key.attachment();
            if (!key.isValid()) {
                key.cancel();
                continue;
            }
            sets.add(actions);
        }
        return sets;
    }

    public List<ActionSet> selectedSets() throws IOException {
        Set<SelectionKey> keys = this.selector.selectedKeys();
        Iterator<SelectionKey> ready = keys.iterator();
        return this.selectedSets(ready);
    }

    private List<ActionSet> selectedSets(Iterator<SelectionKey> keys) {
        LinkedList<ActionSet> ready = new LinkedList<ActionSet>();
        while (keys.hasNext()) {
            SelectionKey key = keys.next();
            ActionSet actions = (ActionSet)key.attachment();
            if (key != null) {
                keys.remove();
            }
            if (key == null) continue;
            ready.add(actions);
        }
        return ready;
    }

    public void wake() throws IOException {
        this.selector.wakeup();
    }

    public void close() throws IOException {
        this.selector.close();
    }
}

