/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport.connect;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.simpleframework.transport.SocketProcessor;
import org.simpleframework.transport.SocketWrapper;
import org.simpleframework.transport.connect.ConnectionEvent;
import org.simpleframework.transport.reactor.Operation;
import org.simpleframework.transport.trace.Trace;
import org.simpleframework.transport.trace.TraceAnalyzer;

class SocketAcceptor
implements Operation {
    private final ServerSocketChannel listener = ServerSocketChannel.open();
    private final SocketProcessor processor;
    private final ServerSocket socket;
    private final SSLContext context;
    private final TraceAnalyzer analyzer;
    private final SocketAddress address;
    private final Trace trace;

    public SocketAcceptor(SocketAddress address, SocketProcessor processor, TraceAnalyzer analyzer) throws IOException {
        this(address, processor, analyzer, null);
    }

    public SocketAcceptor(SocketAddress address, SocketProcessor processor, TraceAnalyzer analyzer, SSLContext context) throws IOException {
        this.trace = analyzer.attach(this.listener);
        this.socket = this.listener.socket();
        this.context = context;
        this.analyzer = analyzer;
        this.processor = processor;
        this.address = address;
    }

    public SocketAddress getAddress() {
        return this.socket.getLocalSocketAddress();
    }

    public Trace getTrace() {
        return this.trace;
    }

    public SelectableChannel getChannel() {
        return this.listener;
    }

    public void bind() throws IOException {
        this.listener.configureBlocking(false);
        this.socket.setReuseAddress(true);
        this.socket.bind(this.address, 100);
    }

    public void run() {
        try {
            this.accept();
        }
        catch (Exception cause) {
            this.pause();
        }
    }

    private void pause() {
        try {
            Thread.sleep(10L);
        }
        catch (Exception cause) {
            this.trace.trace((Object)ConnectionEvent.ERROR, cause);
        }
    }

    public void cancel() {
        try {
            this.close();
        }
        catch (Throwable cause) {
            this.trace.trace((Object)ConnectionEvent.ERROR, cause);
        }
    }

    private void accept() throws IOException {
        SocketChannel channel = this.listener.accept();
        while (channel != null) {
            Trace trace = this.analyzer.attach(channel);
            this.configure(channel);
            if (this.context == null) {
                this.process(channel, trace, null);
            } else {
                this.process(channel, trace);
            }
            channel = this.listener.accept();
        }
    }

    private void configure(SocketChannel channel) throws IOException {
        channel.socket().setTcpNoDelay(true);
        channel.configureBlocking(false);
    }

    private void process(SocketChannel channel, Trace trace) throws IOException {
        SSLEngine engine = this.context.createSSLEngine();
        try {
            this.process(channel, trace, engine);
        }
        catch (Exception cause) {
            trace.trace((Object)ConnectionEvent.ERROR, cause);
            channel.close();
        }
    }

    private void process(SocketChannel channel, Trace trace, SSLEngine engine) throws IOException {
        SocketWrapper socket = new SocketWrapper(channel, trace, engine);
        try {
            trace.trace((Object)ConnectionEvent.ACCEPT);
            this.processor.process(socket);
        }
        catch (Exception cause) {
            trace.trace((Object)ConnectionEvent.ERROR, cause);
            channel.close();
        }
    }

    public void close() throws IOException {
        this.listener.close();
    }
}

