/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.simpleframework.transport.ByteWriter;
import org.simpleframework.transport.Transport;

public class TransportWriter
implements ByteWriter {
    private final AtomicBoolean closed = new AtomicBoolean();
    private final Transport transport;

    public TransportWriter(Transport transport) {
        this.transport = transport;
    }

    public void write(byte[] array) throws IOException {
        this.write(array, 0, array.length);
    }

    public void write(byte[] array, int off, int len) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(array, off, len);
        if (len > 0) {
            this.write(buffer);
        }
    }

    public void write(ByteBuffer buffer) throws IOException {
        int size;
        int mark = buffer.position();
        if (mark > (size = buffer.limit())) {
            throw new IOException("Buffer position greater than limit");
        }
        this.write(buffer, 0, size - mark);
    }

    public void write(ByteBuffer buffer, int off, int len) throws IOException {
        int mark = buffer.position();
        int limit = buffer.limit();
        if (limit - mark > len) {
            buffer.limit(mark + len);
        }
        this.transport.write(buffer);
        buffer.limit(limit);
    }

    public void flush() throws IOException {
        this.transport.flush();
    }

    public void close() throws IOException {
        if (!this.closed.getAndSet(true)) {
            this.transport.close();
        }
    }
}

