/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium;

import com.thoughtworks.selenium.DefaultSelenium;
import com.thoughtworks.selenium.Selenium;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.regex.Pattern;

public class SeleneseTestBase {
    private static final boolean THIS_IS_WINDOWS = File.pathSeparator.equals(";");
    private boolean captureScreenShotOnFailure = false;
    protected Selenium selenium;
    protected StringBuffer verificationErrors = new StringBuffer();

    public void setUp() throws Exception {
        this.setUp(null);
    }

    public void setUp(String url) throws Exception {
        this.setUp(url, this.runtimeBrowserString());
    }

    protected String runtimeBrowserString() {
        String defaultBrowser = System.getProperty("selenium.defaultBrowser");
        if (null != defaultBrowser && defaultBrowser.startsWith("${")) {
            defaultBrowser = null;
        }
        if (defaultBrowser == null) {
            defaultBrowser = THIS_IS_WINDOWS ? "*iexplore" : "*firefox";
        }
        return defaultBrowser;
    }

    public void setUp(String url, String browserString) throws Exception {
        this.setUp(url, browserString, this.getDefaultPort());
    }

    protected int getDefaultPort() {
        try {
            Class<?> c = Class.forName("org.openqa.selenium.server.RemoteControlConfiguration");
            Method getDefaultPort = c.getMethod("getDefaultPort", new Class[0]);
            Integer portNumber = (Integer)getDefaultPort.invoke(null, new Object[0]);
            return portNumber;
        }
        catch (Exception e) {
            return Integer.getInteger("selenium.port", 4444);
        }
    }

    public void setUp(String url, String browserString, int port) throws Exception {
        if (url == null) {
            url = "http://localhost:" + port;
        }
        this.selenium = new DefaultSelenium("localhost", port, browserString, url);
        this.selenium.start();
    }

    public void verifyTrue(boolean b) {
        try {
            SeleneseTestBase.assertTrue(b);
        }
        catch (Error e) {
            this.verificationErrors.append(SeleneseTestBase.throwableToString(e));
        }
    }

    public void verifyFalse(boolean b) {
        try {
            SeleneseTestBase.assertFalse(b);
        }
        catch (Error e) {
            this.verificationErrors.append(SeleneseTestBase.throwableToString(e));
        }
    }

    public String getText() {
        return this.selenium.getEval("this.page().bodyText()");
    }

    public void verifyEquals(Object expected, Object actual) {
        try {
            SeleneseTestBase.assertEquals(expected, actual);
        }
        catch (Error e) {
            this.verificationErrors.append(SeleneseTestBase.throwableToString(e));
        }
    }

    public void verifyEquals(boolean expected, boolean actual) {
        try {
            SeleneseTestBase.assertEquals(expected, actual);
        }
        catch (Error e) {
            this.verificationErrors.append(SeleneseTestBase.throwableToString(e));
        }
    }

    public static void assertEquals(Object expected, Object actual) {
        if (expected instanceof String && actual instanceof String) {
            SeleneseTestBase.assertEquals((String)expected, (String)actual);
        } else if (expected instanceof String && actual instanceof String[]) {
            SeleneseTestBase.assertEquals((String)expected, (String[])actual);
        } else if (expected instanceof String && actual instanceof Number) {
            SeleneseTestBase.assertEquals((String)expected, actual.toString());
        } else if (expected instanceof Number && actual instanceof String) {
            SeleneseTestBase.assertEquals(expected.toString(), (String)actual);
        } else if (expected instanceof String[] && actual instanceof String[]) {
            String[] sa1 = (String[])expected;
            String[] sa2 = (String[])actual;
            if (sa1.length != sa2.length) {
                throw new Error("Expected " + sa1 + " but saw " + sa2);
            }
            for (int j = 0; j < sa1.length; ++j) {
                SeleneseTestBase.assertEquals(sa1[j], sa2[j]);
            }
        } else if (expected == null) {
            SeleneseTestBase.assertTrue(actual == null);
        } else {
            SeleneseTestBase.assertTrue(expected.equals(actual));
        }
    }

    public static void assertEquals(String expected, String actual) {
        SeleneseTestBase.assertTrue("Expected \"" + expected + "\" but saw \"" + actual + "\" instead", SeleneseTestBase.seleniumEquals(expected, actual));
    }

    public static void assertEquals(String expected, String[] actual) {
        SeleneseTestBase.assertEquals(expected, SeleneseTestBase.join(actual, ','));
    }

    public static boolean seleniumEquals(String expectedPattern, String actual) {
        Boolean b;
        if (actual.startsWith("regexp:") || actual.startsWith("regex:") || actual.startsWith("regexpi:") || actual.startsWith("regexi:")) {
            String tmp = actual;
            actual = expectedPattern;
            expectedPattern = tmp;
        }
        if ((b = SeleneseTestBase.handleRegex("regexp:", expectedPattern, actual, 0)) != null) {
            return b;
        }
        b = SeleneseTestBase.handleRegex("regex:", expectedPattern, actual, 0);
        if (b != null) {
            return b;
        }
        b = SeleneseTestBase.handleRegex("regexpi:", expectedPattern, actual, 2);
        if (b != null) {
            return b;
        }
        b = SeleneseTestBase.handleRegex("regexi:", expectedPattern, actual, 2);
        if (b != null) {
            return b;
        }
        if (expectedPattern.startsWith("exact:")) {
            String expectedExact = expectedPattern.replaceFirst("exact:", "");
            if (!expectedExact.equals(actual)) {
                System.out.println("expected " + actual + " to match " + expectedPattern);
                return false;
            }
            return true;
        }
        String expectedGlob = expectedPattern.replaceFirst("glob:", "");
        expectedGlob = expectedGlob.replaceAll("([\\]\\[\\\\{\\}$\\(\\)\\|\\^\\+.])", "\\\\$1");
        expectedGlob = expectedGlob.replaceAll("\\*", ".*");
        if (!Pattern.compile(expectedGlob = expectedGlob.replaceAll("\\?", "."), 32).matcher(actual).matches()) {
            System.out.println("expected \"" + actual + "\" to match glob \"" + expectedPattern + "\" (had transformed the glob into regexp \"" + expectedGlob + "\"");
            return false;
        }
        return true;
    }

    private static Boolean handleRegex(String prefix, String expectedPattern, String actual, int flags) {
        if (expectedPattern.startsWith(prefix)) {
            String expectedRegEx = expectedPattern.replaceFirst(prefix, ".*") + ".*";
            Pattern p = Pattern.compile(expectedRegEx, flags);
            if (!p.matcher(actual).matches()) {
                System.out.println("expected " + actual + " to match regexp " + expectedPattern);
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        return null;
    }

    public static boolean seleniumEquals(Object expected, Object actual) {
        if (expected instanceof String && actual instanceof String) {
            return SeleneseTestBase.seleniumEquals((String)expected, (String)actual);
        }
        return expected.equals(actual);
    }

    public static void assertEquals(String[] expected, String[] actual) {
        String comparisonDumpIfNotEqual = SeleneseTestBase.verifyEqualsAndReturnComparisonDumpIfNot(expected, actual);
        if (comparisonDumpIfNotEqual != null) {
            throw new AssertionError((Object)comparisonDumpIfNotEqual);
        }
    }

    public void verifyEquals(String[] expected, String[] actual) {
        String comparisonDumpIfNotEqual = SeleneseTestBase.verifyEqualsAndReturnComparisonDumpIfNot(expected, actual);
        if (comparisonDumpIfNotEqual != null) {
            this.verificationErrors.append(comparisonDumpIfNotEqual);
        }
    }

    private static String verifyEqualsAndReturnComparisonDumpIfNot(String[] expected, String[] actual) {
        boolean misMatch = false;
        if (expected.length != actual.length) {
            misMatch = true;
        }
        for (int j = 0; j < expected.length; ++j) {
            if (SeleneseTestBase.seleniumEquals(expected[j], actual[j])) continue;
            misMatch = true;
            break;
        }
        if (misMatch) {
            return "Expected " + SeleneseTestBase.stringArrayToString(expected) + " but saw " + SeleneseTestBase.stringArrayToString(actual);
        }
        return null;
    }

    private static String stringArrayToString(String[] sa) {
        StringBuffer sb = new StringBuffer("{");
        for (int j = 0; j < sa.length; ++j) {
            sb.append(" ").append("\"").append(sa[j]).append("\"");
        }
        sb.append(" }");
        return sb.toString();
    }

    private static String throwableToString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    public static String join(String[] sa, char c) {
        StringBuffer sb = new StringBuffer();
        for (int j = 0; j < sa.length; ++j) {
            sb.append(sa[j]);
            if (j >= sa.length - 1) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public void verifyNotEquals(Object expected, Object actual) {
        try {
            SeleneseTestBase.assertNotEquals(expected, actual);
        }
        catch (AssertionError e) {
            this.verificationErrors.append(SeleneseTestBase.throwableToString((Throwable)((Object)e)));
        }
    }

    public void verifyNotEquals(boolean expected, boolean actual) {
        try {
            SeleneseTestBase.assertNotEquals((Object)expected, (Object)actual);
        }
        catch (AssertionError e) {
            this.verificationErrors.append(SeleneseTestBase.throwableToString((Throwable)((Object)e)));
        }
    }

    public static void assertNotEquals(Object expected, Object actual) {
        if (expected.equals(actual)) {
            SeleneseTestBase.fail("did not expect (" + actual.toString() + ") to be equal to (" + expected.toString() + ")");
        }
    }

    public static void fail(String message) {
        throw new AssertionError((Object)message);
    }

    public static void assertTrue(String message, boolean condition) {
        if (!condition) {
            SeleneseTestBase.fail(message);
        }
    }

    public static void assertTrue(boolean condition) {
        SeleneseTestBase.assertTrue(null, condition);
    }

    public static void assertFalse(String message, boolean condition) {
        SeleneseTestBase.assertTrue(message, !condition);
    }

    public static void assertFalse(boolean condition) {
        SeleneseTestBase.assertTrue(null, !condition);
    }

    public static void assertNotEquals(boolean expected, boolean actual) {
        SeleneseTestBase.assertNotEquals((Object)expected, (Object)actual);
    }

    public void pause(int millisecs) {
        try {
            Thread.sleep(millisecs);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void checkForVerificationErrors() {
        String verificationErrorString = this.verificationErrors.toString();
        this.clearVerificationErrors();
        if (!"".equals(verificationErrorString)) {
            SeleneseTestBase.fail(verificationErrorString);
        }
    }

    public void clearVerificationErrors() {
        this.verificationErrors = new StringBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tearDown() throws Exception {
        try {
            this.checkForVerificationErrors();
        }
        finally {
            if (this.selenium != null) {
                this.selenium.stop();
                this.selenium = null;
            }
        }
    }

    protected boolean isCaptureScreenShotOnFailure() {
        return this.captureScreenShotOnFailure;
    }

    protected void setCaptureScreenShotOnFailure(boolean captureScreetShotOnFailure) {
        this.captureScreenShotOnFailure = captureScreetShotOnFailure;
    }
}

