/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.function.Function;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Routable;

@FunctionalInterface
public interface Filter
extends Function<HttpHandler, HttpHandler> {
    default public Filter andThen(Filter next) {
        Objects.requireNonNull(next, "Next filter must be set.");
        return req -> (HttpHandler)this.apply((HttpHandler)next.apply(req));
    }

    default public HttpHandler andFinally(HttpHandler end) {
        Objects.requireNonNull(end, "HTTP handler must be set.");
        return request -> ((HttpHandler)this.apply(end)).execute(request);
    }

    default public Routable andFinally(final Routable end) {
        return new Routable(){

            @Override
            public HttpResponse execute(HttpRequest req) throws UncheckedIOException {
                return ((HttpHandler)Filter.this.apply(end)).execute(req);
            }

            @Override
            public boolean matches(HttpRequest req) {
                return end.matches(req);
            }
        };
    }
}

