/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util;

class UnsafeRandom {
    private long seed;
    private static final long MUL = 25214903917L;
    private static final long ADD = 11L;
    private static final long MSK = 0xFFFFFFFFFFFFL;

    UnsafeRandom(long seed) {
        this.seed = seed ^ 0x5DEECE66DL;
    }

    private long next() {
        this.seed = this.seed * 25214903917L + 11L;
        return this.seed;
    }

    private int next(int bits) {
        return (int)((this.next() & 0xFFFFFFFFFFFFL) >> 48 - bits);
    }

    int nextInt(int bound) {
        int r = this.next(31);
        int m = bound - 1;
        if ((bound & m) == 0) {
            r = (int)((long)bound * (long)r >> 31);
        } else {
            int u = r;
            while (u - (r = u % bound) + m < 0) {
                u = this.next(31);
            }
        }
        return r;
    }
}

