/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util;

import javax.vecmath.Vector3d;

public final class MathUtils {
    public static final double TWO_PI = Math.PI * 2;
    private static final float[][] DISTANCES_2D;
    private static final float[][][] DISTANCES_3D;
    private static final int[][] INTEGER_POWERS;

    private MathUtils() {
    }

    public static int pow(int x, int y) {
        if (x >= 0 && x < 50 && y >= 0 && y < 50) {
            return INTEGER_POWERS[x][y];
        }
        switch (y) {
            case 0: {
                return 1;
            }
            case 1: {
                return x;
            }
            case 2: {
                return x * x;
            }
            case 3: {
                return x * x * x;
            }
        }
        if (y < 0) {
            throw new IllegalArgumentException("y " + y + " < 0");
        }
        for (int i = 1; i < y; ++i) {
            x *= x;
        }
        return x;
    }

    public static float mod(float a, float b) {
        if (a < 0.0f) {
            return a + (float)Math.ceil(-a / b) * b;
        }
        if (a >= b) {
            return a - (float)Math.floor(a / b) * b;
        }
        return a;
    }

    public static double mod(double a, double b) {
        if (a < 0.0) {
            return a + Math.ceil(-a / b) * b;
        }
        if (a >= b) {
            return a - Math.floor(a / b) * b;
        }
        return a;
    }

    public static int mod(int a, int b) {
        if (a < 0) {
            return (a % b + b) % b;
        }
        return a % b;
    }

    public static float getDistance(int x1, int y1, int x2, int y2) {
        return MathUtils.getDistance(x2 - x1, y2 - y1);
    }

    public static float getDistance(int x1, int y1, int z1, int x2, int y2, int z2) {
        return MathUtils.getDistance(x2 - x1, y2 - y1, z2 - z1);
    }

    public static float getDistance(int dx, int dy) {
        dx = Math.abs(dx);
        dy = Math.abs(dy);
        if (dx <= 300 && dy <= 300) {
            return DISTANCES_2D[dx][dy];
        }
        return (float)Math.sqrt(dx * dx + dy * dy);
    }

    public static float getDistance(float dx, float dy) {
        return (float)Math.sqrt(dx * dx + dy * dy);
    }

    public static float getDistance(float dx, float dy, float dz) {
        double d = Math.sqrt(dx * dx + dy * dy);
        return (float)Math.sqrt(d * d + (double)(dz * dz));
    }

    public static double getDistance(double dx, double dy, double dz) {
        double d = Math.sqrt(dx * dx + dy * dy);
        return Math.sqrt(d * d + dz * dz);
    }

    public static float getDistance(int dx, int dy, int dz) {
        dx = Math.abs(dx);
        dy = Math.abs(dy);
        dz = Math.abs(dz);
        if (dx <= 50 && dy <= 50 && dz <= 50) {
            return DISTANCES_3D[dx][dy][dz];
        }
        return (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static int clamp(int min, int value, int max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static long clamp(long min, long value, long max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static float clamp(float min, float value, float max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static double clamp(double min, double value, double max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static Vector3d rotateVectorCC(Vector3d vector, Vector3d axis, double angle) {
        double x = vector.x;
        double y = vector.y;
        double z = vector.z;
        double u = axis.x;
        double v = axis.y;
        double w = axis.z;
        double cosAngle = Math.cos(angle);
        double sinAngle = Math.sin(angle);
        double product = u * x + v * y + w * z;
        double xPrime = u * product * (1.0 - cosAngle) + x * cosAngle + (-w * y + v * z) * sinAngle;
        double yPrime = v * product * (1.0 - cosAngle) + y * cosAngle + (w * x - u * z) * sinAngle;
        double zPrime = w * product * (1.0 - cosAngle) + z * cosAngle + (-v * x + u * y) * sinAngle;
        return new Vector3d(xPrime, yPrime, zPrime);
    }

    public static double distanceToLineSegment(int px, int py, int vx, int vy, int wx, int wy) {
        return Math.sqrt(MathUtils.distToSegmentSquared(vx, vy, wx, wy, px, py));
    }

    private static double dist2(double x1, double y1, double x2, double y2) {
        return (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2);
    }

    private static double distToSegmentSquared(long vx, long vy, long wx, long wy, long px, long py) {
        double l2 = MathUtils.dist2(vx, vy, wx, wy);
        if (l2 == 0.0) {
            return MathUtils.dist2(px, py, vx, vy);
        }
        double t = (double)((px - vx) * (wx - vx) + (py - vy) * (wy - vy)) / l2;
        t = Math.max(0.0, Math.min(1.0, t));
        return MathUtils.dist2(px, py, (double)vx + t * (double)(wx - vx), (double)vy + t * (double)(wy - vy));
    }

    static {
        int dy;
        int dx;
        DISTANCES_2D = new float[301][301];
        DISTANCES_3D = new float[51][51][51];
        INTEGER_POWERS = new int[50][50];
        for (dx = 0; dx <= 300; ++dx) {
            for (dy = 0; dy <= 300; ++dy) {
                MathUtils.DISTANCES_2D[dx][dy] = (float)Math.sqrt(dx * dx + dy * dy);
            }
        }
        for (dx = 0; dx <= 50; ++dx) {
            for (dy = 0; dy <= 50; ++dy) {
                for (int dz = 0; dz <= 50; ++dz) {
                    MathUtils.DISTANCES_3D[dx][dy][dz] = (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
                }
            }
        }
        for (int x = 0; x < 50; ++x) {
            for (int y = 0; y < 50; ++y) {
                long n = 1L;
                for (int i = 0; i < y; ++i) {
                    if ((n *= (long)x) <= Integer.MAX_VALUE) continue;
                    n = Integer.MAX_VALUE;
                    break;
                }
                MathUtils.INTEGER_POWERS[x][y] = (int)n;
            }
        }
    }
}

