/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util;

import com.google.common.base.Strings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CSVDataSource {
    private BufferedReader in;
    private Writer out;
    private Map<String, Integer> columnsByName;
    private List<String> columnsByIndex;
    private List<String> currentRow;

    public void openForReading(Reader in) throws IOException {
        if (this.in != null || this.out != null) {
            throw new IllegalStateException("Already open");
        }
        this.in = in instanceof BufferedReader ? (BufferedReader)in : new BufferedReader(in);
        this.readHeaders();
        this.readValues();
    }

    public void openForWriting(Writer out, String ... columnNames) throws IOException {
        if (this.in != null || this.out != null) {
            throw new IllegalStateException("Already open");
        }
        this.out = out;
        this.columnsByIndex = Arrays.asList(columnNames);
        this.columnsByName = new HashMap<String, Integer>();
        for (int i = 0; i < columnNames.length; ++i) {
            this.columnsByName.put(columnNames[i], i);
        }
        this.writeHeaders();
        this.currentRow = Arrays.asList(new String[columnNames.length]);
    }

    public boolean isEndOfFile() {
        return this.currentRow == null;
    }

    public void next() throws IOException {
        if (this.in != null) {
            this.readValues();
        } else {
            this.writeValues();
        }
    }

    public String getString(String columnName) {
        this.checkColumnName(columnName);
        return this.getString(this.columnsByName.get(columnName));
    }

    public String getString(String columnName, String defaultValue) {
        return this.columnsByName.containsKey(columnName) ? this.getString(this.columnsByName.get(columnName), defaultValue) : defaultValue;
    }

    public String getString(int columnIndex) {
        return this.currentRow.get(columnIndex);
    }

    public String getString(int columnIndex, String defaultValue) {
        String value = this.currentRow.get(columnIndex);
        return Strings.isNullOrEmpty((String)value) ? defaultValue : value;
    }

    public void setString(String columnName, String value) {
        this.checkColumnName(columnName);
        this.setString(this.columnsByName.get(columnName), value);
    }

    public void setString(int columnIndex, String value) {
        this.currentRow.set(columnIndex, value);
    }

    public int getInt(String columnName) {
        this.checkColumnName(columnName);
        try {
            return Integer.parseInt(this.getString(columnName));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Not a valid integer value for column " + columnName + ": \"" + this.getString(columnName) + "\"", e);
        }
    }

    public int getInt(String columnName, int defaultValue) {
        if (!this.columnsByName.containsKey(columnName)) {
            return defaultValue;
        }
        String stringValue = this.getString(columnName);
        try {
            return stringValue != null ? Integer.parseInt(stringValue) : defaultValue;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Not a valid integer value for column " + columnName + ": \"" + this.getString(columnName) + "\"", e);
        }
    }

    public void setInt(String columnName, int value) {
        this.checkColumnName(columnName);
        this.setString(columnName, Integer.toString(value));
    }

    public boolean getBoolean(String columnName) {
        this.checkColumnName(columnName);
        return Boolean.parseBoolean(this.getString(columnName));
    }

    public boolean getBoolean(String columnName, boolean defaultValue) {
        if (!this.columnsByName.containsKey(columnName)) {
            return defaultValue;
        }
        String stringValue = this.getString(columnName);
        return stringValue != null ? Boolean.parseBoolean(stringValue) : defaultValue;
    }

    public void setBoolean(String columnName, boolean value) {
        this.checkColumnName(columnName);
        this.setString(columnName, Boolean.toString(value));
    }

    private void checkColumnName(String columnName) {
        if (!this.columnsByName.containsKey(columnName)) {
            throw new IllegalArgumentException("There is no column named \"" + columnName + "\"");
        }
    }

    private void readHeaders() throws IOException {
        List<String> headers = this.readLine();
        this.columnsByName = new HashMap<String, Integer>();
        for (int i = 0; i < headers.size(); ++i) {
            this.columnsByName.put(headers.get(i), i);
        }
    }

    private void writeHeaders() throws IOException {
        this.out.write(this.columnsByIndex.stream().map(this::quoteIfNecessary).collect(Collectors.joining(",")));
    }

    private void readValues() throws IOException {
        this.currentRow = this.readLine();
    }

    private void writeValues() throws IOException {
        this.out.write("\r\n");
        this.out.write(this.currentRow.stream().map(str -> str != null ? str : "").map(this::quoteIfNecessary).collect(Collectors.joining(",")));
        this.currentRow.replaceAll(str -> null);
    }

    private String quoteIfNecessary(String text) {
        return text.contains(",") || text.contains("\"") ? "\"" + text.replace("\"", "\"\"") + "\"" : text;
    }

    private List<String> readLine() throws IOException {
        String line = this.in.readLine();
        if (line == null) {
            return null;
        }
        ArrayList<String> values = new ArrayList<String>();
        StringBuilder currentValue = new StringBuilder();
        boolean IDLE = false;
        boolean READING_QUOTED_VALUE = true;
        int READING_UNQUOTED_VALUE = 2;
        int QUOTE_ENCOUNTERED_IN_QUOTED_VALUE = 3;
        int state = 0;
        block10: for (char c : line.toCharArray()) {
            switch (state) {
                case 0: {
                    if (c == '\"') {
                        state = 1;
                        continue block10;
                    }
                    if (c == ',') {
                        values.add(currentValue.toString());
                        currentValue.setLength(0);
                        continue block10;
                    }
                    currentValue.append(c);
                    state = 2;
                    continue block10;
                }
                case 1: {
                    if (c == '\"') {
                        state = 3;
                        continue block10;
                    }
                    currentValue.append(c);
                    continue block10;
                }
                case 2: {
                    if (c == ',') {
                        values.add(currentValue.toString());
                        currentValue.setLength(0);
                        state = 0;
                        continue block10;
                    }
                    currentValue.append(c);
                    continue block10;
                }
                case 3: {
                    if (c == '\"') {
                        currentValue.append('\"');
                        state = 1;
                        continue block10;
                    }
                    if (c == ',') {
                        values.add(currentValue.toString());
                        currentValue.setLength(0);
                        state = 0;
                        continue block10;
                    }
                    throw new IOException("Single double quote encountered in quoted field (line: \"" + line + "\")");
                }
            }
        }
        switch (state) {
            case 0: 
            case 2: 
            case 3: {
                values.add(currentValue.toString());
                break;
            }
            case 1: {
                throw new IOException("Quoted field not closed (line: \"" + line + "\")");
            }
        }
        return values;
    }
}

