/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util.jobqueue;

import org.pepsoft.util.jobqueue.Job;
import org.pepsoft.util.jobqueue.UniqueJobQueue;

public final class BackgroundJobManager {
    final Object queueLock = new Object();
    boolean running = true;
    private final UniqueJobQueue<Job>[] queues;
    private final BackgroundJobThread[] threads;

    public BackgroundJobManager(int priorities) {
        this(priorities, Math.max(Runtime.getRuntime().availableProcessors() - 1, 1));
    }

    public BackgroundJobManager(int priorities, int threads) {
        if (priorities < 1 || threads < 1) {
            throw new IllegalArgumentException();
        }
        this.queues = new UniqueJobQueue[priorities];
        this.threads = new BackgroundJobThread[threads];
    }

    public void submitJob(Job job) {
        this.submitJob(job, 1);
    }

    public void submitJob(Job job, int priority) {
        if (job == null) {
            throw new NullPointerException();
        }
        if (priority < 1 || priority >= this.queues.length) {
            throw new IllegalArgumentException();
        }
        this.queues[priority - 1].scheduleJobIfNotScheduled(job);
    }

    public void insertJob(Job job) {
        this.insertJob(job, 1);
    }

    public void insertJob(Job job, int priority) {
        if (job == null) {
            throw new NullPointerException();
        }
        if (priority < 1 || priority >= this.queues.length) {
            throw new IllegalArgumentException();
        }
        this.queues[priority - 1].rescheduleJob(job);
    }

    public void removeJob(Job job) {
        for (UniqueJobQueue<Job> queue : this.queues) {
            if (!queue.removeJob(job)) continue;
            return;
        }
    }

    public void start() {
    }

    public void stop() {
    }

    class BackgroundJobThread
    extends Thread {
        BackgroundJobThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (BackgroundJobManager.this.running) {
                Job job = null;
                Object object = BackgroundJobManager.this.queueLock;
                synchronized (object) {
                    do {
                        UniqueJobQueue<Job> queue;
                        UniqueJobQueue<Job>[] uniqueJobQueueArray = BackgroundJobManager.this.queues;
                        int n = uniqueJobQueueArray.length;
                        for (int i = 0; i < n && (job = (queue = uniqueJobQueueArray[i]).pollJob()) == null; ++i) {
                        }
                    } while (BackgroundJobManager.this.running && job == null);
                }
            }
        }
    }
}

