/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.pepsoft.util.mdc.MDCCapturingRuntimeException;

public class ProcessUtils {
    public static void runInBackground(String ... args) {
        try {
            Process process = Runtime.getRuntime().exec(args);
            StreamCopier stdoutCopier = new StreamCopier(args[0] + " stdout", process.getInputStream(), System.out);
            StreamCopier stderrCopier = new StreamCopier(args[0] + " stderr", process.getErrorStream(), System.err);
            stdoutCopier.start();
            stderrCopier.start();
        }
        catch (IOException e) {
            throw new MDCCapturingRuntimeException("I/O error while trying to execute " + Arrays.asList(args), e);
        }
    }

    public static int runAndWait(String ... args) {
        try {
            Process process = Runtime.getRuntime().exec(args);
            StreamCopier stdoutCopier = new StreamCopier(args[0] + " stdout", process.getInputStream(), System.out);
            StreamCopier stderrCopier = new StreamCopier(args[0] + " stderr", process.getErrorStream(), System.err);
            stdoutCopier.start();
            stderrCopier.start();
            return process.waitFor();
        }
        catch (IOException e) {
            throw new MDCCapturingRuntimeException("I/O error while trying to execute " + Arrays.asList(args), e);
        }
        catch (InterruptedException e) {
            throw new MDCCapturingRuntimeException("Thread interrupted while waiting for " + Arrays.asList(args) + " to finish", e);
        }
    }

    static class StreamCopier
    extends Thread {
        private final InputStream in;
        private final OutputStream out;

        StreamCopier(String name, InputStream in, OutputStream out) {
            super(name);
            this.in = in;
            this.out = out;
        }

        @Override
        public void run() {
            try {
                int read;
                byte[] buffer = new byte[32768];
                while ((read = this.in.read(buffer)) != -1) {
                    this.out.write(buffer, 0, read);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

