/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.pepsoft.util.FastPerlin;
import org.pepsoft.util.mdc.MDCCapturingRuntimeException;
import org.pepsoft.util.mdc.MDCWrappingRuntimeException;

public final class PerlinNoise
implements Serializable,
Cloneable {
    private long seed;
    private FastPerlin fastPerlin;
    private static final double FACTOR_2D = 0.5;
    private static final double FACTOR_3D = 0.4824607142760952;
    private static final long serialVersionUID = 2011040701L;
    private static final float[] LEVEL_FOR_PROMILLAGE = new float[10001];

    public PerlinNoise(long seed) {
        this.seed = seed;
        this.fastPerlin = new FastPerlin(seed);
    }

    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long seed) {
        if (seed != this.seed) {
            this.seed = seed;
            this.fastPerlin = new FastPerlin(seed);
        }
    }

    public float getPerlinNoise(double x) {
        return this.fastPerlin.sampleResult(x);
    }

    public float getPerlinNoise(double x, double y) {
        return (float)((double)this.fastPerlin.sampleResult(x, y) * 0.5);
    }

    public float getPerlinNoise(double x, double y, double z) {
        return (float)((double)this.fastPerlin.sampleResult(x, y, z) * 0.4824607142760952);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new MDCWrappingRuntimeException(e);
        }
    }

    public static float getLevelForPromillage(int promillage) {
        return PerlinNoise.getLevelForPromillage((float)promillage);
    }

    public static float getLevelForPromillage(float promillage) {
        if (promillage < 0.0f || promillage > 1000.0f) {
            throw new IllegalArgumentException();
        }
        if ((promillage *= 10.0f) == (float)((int)promillage)) {
            return LEVEL_FOR_PROMILLAGE[(int)promillage];
        }
        float level1 = LEVEL_FOR_PROMILLAGE[(int)promillage];
        return level1 + (LEVEL_FOR_PROMILLAGE[(int)promillage + 1] - level1) * (promillage - (float)((int)promillage));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.fastPerlin == null) {
            this.fastPerlin = new FastPerlin(this.seed);
        }
    }

    static {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(PerlinNoise.class.getResourceAsStream("noiselevels.txt")));){
            String line;
            int index = 0;
            while ((line = in.readLine()) != null) {
                for (String token : line.split("[ ,]+")) {
                    PerlinNoise.LEVEL_FOR_PROMILLAGE[index++] = Float.parseFloat(token);
                }
            }
        }
        catch (IOException e) {
            throw new MDCCapturingRuntimeException("I/O error while trying to load noise levels from classpath", e);
        }
    }
}

