/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util;

import java.awt.Point;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.pepsoft.util.Immutable;
import org.pepsoft.util.undo.Cloneable;

public final class ObjectUtils {
    private ObjectUtils() {
    }

    public static <T> T copyObject(T object) {
        if (object == null || object instanceof Number || object instanceof Character || object instanceof Boolean || object instanceof String || object instanceof Enum || object instanceof Point || object instanceof Immutable) {
            return object;
        }
        if (object instanceof BitSet) {
            return (T)((BitSet)object).clone();
        }
        if (object instanceof EnumSet) {
            return (T)((EnumSet)object).clone();
        }
        if (object instanceof byte[]) {
            return (T)((byte[])object).clone();
        }
        if (object instanceof short[]) {
            return (T)((short[])object).clone();
        }
        if (object instanceof int[]) {
            return (T)((int[])object).clone();
        }
        if (object instanceof long[]) {
            return (T)((long[])object).clone();
        }
        if (object instanceof float[]) {
            return (T)((float[])object).clone();
        }
        if (object instanceof double[]) {
            return (T)((double[])object).clone();
        }
        if (object instanceof String[]) {
            return (T)((String[])object).clone();
        }
        if (object instanceof Map) {
            AbstractMap copy = object instanceof SortedMap ? new TreeMap() : new HashMap(((Map)object).size());
            for (Map.Entry entry : ((Map)object).entrySet()) {
                copy.put(entry.getKey(), ObjectUtils.copyObject(entry.getValue()));
            }
            return (T)copy;
        }
        if (object instanceof List) {
            AbstractList copy = object instanceof RandomAccess ? new ArrayList(((List)object).size()) : new LinkedList();
            for (Object entry : (List)object) {
                copy.add(ObjectUtils.copyObject(entry));
            }
            return (T)copy;
        }
        if (object instanceof Set) {
            AbstractSet copy = object instanceof SortedSet ? new TreeSet() : new HashSet(((Set)object).size());
            for (Object entry : (Set)object) {
                copy.add(ObjectUtils.copyObject(entry));
            }
            return (T)copy;
        }
        if (object instanceof Cloneable) {
            return ((Cloneable)object).clone();
        }
        throw new UnsupportedOperationException("Don't know how to copy a " + object.getClass());
    }

    public static DataBuffer clone(DataBuffer dataBuffer) {
        if (dataBuffer instanceof DataBufferByte) {
            return ObjectUtils.clone((DataBufferByte)dataBuffer);
        }
        if (dataBuffer instanceof DataBufferDouble) {
            return ObjectUtils.clone((DataBufferDouble)dataBuffer);
        }
        if (dataBuffer instanceof DataBufferFloat) {
            return ObjectUtils.clone((DataBufferFloat)dataBuffer);
        }
        if (dataBuffer instanceof DataBufferInt) {
            return ObjectUtils.clone((DataBufferInt)dataBuffer);
        }
        if (dataBuffer instanceof DataBufferShort) {
            return ObjectUtils.clone((DataBufferShort)dataBuffer);
        }
        if (dataBuffer instanceof DataBufferUShort) {
            return ObjectUtils.clone((DataBufferUShort)dataBuffer);
        }
        throw new UnsupportedOperationException("Don't know how to clone " + dataBuffer.getClass().getName());
    }

    public static DataBufferByte clone(DataBufferByte dataBuffer) {
        return new DataBufferByte(ObjectUtils.clone(dataBuffer.getBankData()), dataBuffer.getSize(), dataBuffer.getOffsets());
    }

    public static DataBufferDouble clone(DataBufferDouble dataBuffer) {
        return new DataBufferDouble(ObjectUtils.clone(dataBuffer.getBankData()), dataBuffer.getSize(), dataBuffer.getOffsets());
    }

    public static DataBufferFloat clone(DataBufferFloat dataBuffer) {
        return new DataBufferFloat(ObjectUtils.clone(dataBuffer.getBankData()), dataBuffer.getSize(), dataBuffer.getOffsets());
    }

    public static DataBufferInt clone(DataBufferInt dataBuffer) {
        return new DataBufferInt(ObjectUtils.clone(dataBuffer.getBankData()), dataBuffer.getSize(), dataBuffer.getOffsets());
    }

    public static DataBufferShort clone(DataBufferShort dataBuffer) {
        return new DataBufferShort(ObjectUtils.clone(dataBuffer.getBankData()), dataBuffer.getSize(), dataBuffer.getOffsets());
    }

    public static DataBufferUShort clone(DataBufferUShort dataBuffer) {
        return new DataBufferUShort(ObjectUtils.clone(dataBuffer.getBankData()), dataBuffer.getSize(), dataBuffer.getOffsets());
    }

    public static byte[][] clone(byte[][] array) {
        byte[][] clone = new byte[array.length][];
        for (int i = 0; i < array.length; ++i) {
            clone[i] = (byte[])array[i].clone();
        }
        return clone;
    }

    public static double[][] clone(double[][] array) {
        double[][] clone = new double[array.length][];
        for (int i = 0; i < array.length; ++i) {
            clone[i] = (double[])array[i].clone();
        }
        return clone;
    }

    public static float[][] clone(float[][] array) {
        float[][] clone = new float[array.length][];
        for (int i = 0; i < array.length; ++i) {
            clone[i] = (float[])array[i].clone();
        }
        return clone;
    }

    public static int[][] clone(int[][] array) {
        int[][] clone = new int[array.length][];
        for (int i = 0; i < array.length; ++i) {
            clone[i] = (int[])array[i].clone();
        }
        return clone;
    }

    public static short[][] clone(short[][] array) {
        short[][] clone = new short[array.length][];
        for (int i = 0; i < array.length; ++i) {
            clone[i] = (short[])array[i].clone();
        }
        return clone;
    }

    @SafeVarargs
    @NotNull
    public static <T> T coalesce(T firstValue, Supplier<T> ... subsequentValueSuppliers) {
        if (firstValue != null) {
            return firstValue;
        }
        for (Supplier<T> subsequentValueSupplier : subsequentValueSuppliers) {
            T value = subsequentValueSupplier.get();
            if (value == null) continue;
            return value;
        }
        throw new NullPointerException("All suppliers returned null");
    }
}

