/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util;

import org.pepsoft.util.UnsafeRandom;

public class FastPerlin {
    private final short[] permPair = new short[256];
    private static final float[] LUT2 = new float[]{1.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f, -1.0f, 0.0f, -1.0f, -1.0f, 0.0f, 1.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 1.0f, 0.0f, -1.0f, -1.0f, 0.0f, -1.0f, 0.0f, 1.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f, -1.0f, 0.0f, -1.0f, -1.0f, 1.0f, 1.0f, 0.0f, 0.0f, -1.0f, 1.0f, -1.0f, 1.0f, 0.0f, 0.0f, -1.0f, -1.0f};

    public FastPerlin(long seed) {
        int i;
        UnsafeRandom r = new UnsafeRandom(seed);
        byte[] permutation = new byte[256];
        for (i = 0; i < 256; ++i) {
            permutation[i] = (byte)i;
        }
        for (i = 0; i < 256; ++i) {
            int j = r.nextInt(256 - i);
            byte b = permutation[255 - i];
            permutation[255 - i] = permutation[j];
            permutation[j] = b;
        }
        for (i = 0; i < 256; ++i) {
            this.permPair[i] = (short)(permutation[i] & 0xFF | (permutation[i + 1 & 0xFF] & 0xFF) << 8);
        }
    }

    private static float fade(float v) {
        return v * v * v * Math.fma(v, Math.fma(v, 6.0f, -15.0f), 10.0f);
    }

    private int getPair(int idx) {
        return this.permPair[idx & 0xFF] & 0xFFFF;
    }

    public float sampleResult(double X) {
        float lx = (float)(X - Math.floor(X));
        int x = this.getPair((int)Math.floor(X));
        return FastPerlin.lerp(FastPerlin.fade(lx), FastPerlin.grad(this.getPair(this.getPair(x)), lx), FastPerlin.grad(this.getPair(this.getPair(x >> 8)), lx - 1.0f));
    }

    public float sampleResult(double X, double Y) {
        int by = (int)Math.floor(Y);
        float lx = (float)(X - Math.floor(X));
        float ly = (float)(Y - Math.floor(Y));
        int x = this.getPair((int)Math.floor(X));
        int x0y = this.getPair(x + by);
        int x1y = this.getPair((x >> 8) + by);
        float py = FastPerlin.fade(ly);
        return FastPerlin.lerp(FastPerlin.fade(lx), FastPerlin.lerp(py, FastPerlin.grad(this.getPair(x0y), lx, ly), FastPerlin.grad(this.getPair(x0y >> 8), lx, ly - 1.0f)), FastPerlin.lerp(py, FastPerlin.grad(this.getPair(x1y), lx - 1.0f, ly), FastPerlin.grad(this.getPair(x1y >> 8), lx - 1.0f, ly - 1.0f)));
    }

    public float sampleResult(double X, double Y, double Z) {
        int bx = (int)Math.floor(X);
        int by = (int)Math.floor(Y);
        int bz = (int)Math.floor(Z);
        float lx = (float)(X - Math.floor(X));
        float ly = (float)(Y - Math.floor(Y));
        float lz = (float)(Z - Math.floor(Z));
        int x = this.getPair(bx);
        int x0y = this.getPair(x + by);
        int x1y = this.getPair((x >> 8) + by);
        int x0y0z = this.getPair(x0y + bz);
        int x0y1z = this.getPair((x0y >> 8) + bz);
        int x1y0z = this.getPair(x1y + bz);
        int x1y1z = this.getPair((x1y >> 8) + bz);
        float py = FastPerlin.fade(ly);
        float pz = FastPerlin.fade(lz);
        return FastPerlin.lerp(FastPerlin.fade(lx), FastPerlin.lerp(py, FastPerlin.lerp(pz, FastPerlin.grad(x0y0z, lx, ly, lz), FastPerlin.grad(x0y0z >> 8, lx, ly, lz - 1.0f)), FastPerlin.lerp(pz, FastPerlin.grad(x0y1z, lx, ly - 1.0f, lz), FastPerlin.grad(x0y1z >> 8, lx, ly - 1.0f, lz - 1.0f))), FastPerlin.lerp(py, FastPerlin.lerp(pz, FastPerlin.grad(x1y0z, lx - 1.0f, ly, lz), FastPerlin.grad(x1y0z >> 8, lx - 1.0f, ly, lz - 1.0f)), FastPerlin.lerp(pz, FastPerlin.grad(x1y1z, lx - 1.0f, ly - 1.0f, lz), FastPerlin.grad(x1y1z >> 8, lx - 1.0f, ly - 1.0f, lz - 1.0f))));
    }

    private static float grad(int v, float x, float y, float z) {
        v = (v & 0xF) * 3;
        return Math.fma(x, LUT2[v], Math.fma(y, LUT2[v + 1], z * LUT2[v + 2]));
    }

    private static float grad(int v, float x) {
        v = (v & 0xF) * 3;
        return x * LUT2[v];
    }

    private static float grad(int v, float x, float y) {
        v = (v & 0xF) * 3;
        return Math.fma(x, LUT2[v], y * LUT2[v + 1]);
    }

    private static float lerp(float progress, float a, float b) {
        return Math.fma(b - a, progress, a);
    }
}

