/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util;

public final class ExceptionUtils {
    private ExceptionUtils() {
    }

    public static Throwable getUltimateCause(Throwable t) {
        Throwable cause = t;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        return cause;
    }

    public static boolean chainContains(Throwable exception, Class<? extends Throwable> exceptionType) {
        return ExceptionUtils.getFromChainOfType(exception, exceptionType) != null;
    }

    public static <T extends Throwable> T getFromChainOfType(Throwable exception, Class<T> exceptionType) {
        Throwable cause = exception;
        do {
            if (!exceptionType.isAssignableFrom(cause.getClass())) continue;
            return (T)cause;
        } while ((cause = cause.getCause()) != null);
        return null;
    }
}

