/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.uni;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.optaplanner.constraint.streams.bavet.BavetConstraint;
import org.optaplanner.constraint.streams.bavet.BavetConstraintFactory;
import org.optaplanner.constraint.streams.bavet.common.BavetAbstractConstraintStream;
import org.optaplanner.constraint.streams.bavet.common.BavetScoringConstraintStream;
import org.optaplanner.constraint.streams.bavet.common.NodeBuildHelper;
import org.optaplanner.constraint.streams.bavet.uni.BavetAbstractUniConstraintStream;
import org.optaplanner.constraint.streams.bavet.uni.UniScorer;
import org.optaplanner.constraint.streams.common.inliner.AbstractScoreInliner;
import org.optaplanner.constraint.streams.common.inliner.JustificationsSupplier;
import org.optaplanner.constraint.streams.common.inliner.UndoScoreImpacter;
import org.optaplanner.constraint.streams.common.inliner.WeightedScoreImpacter;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintJustification;
import org.optaplanner.core.api.score.stream.ConstraintStream;

public final class BavetScoringUniConstraintStream<Solution_, A>
extends BavetAbstractUniConstraintStream<Solution_, A>
implements BavetScoringConstraintStream<Solution_> {
    private final BavetAbstractUniConstraintStream<Solution_, A> parent;
    private final boolean noMatchWeigher;
    private final ToIntFunction<A> intMatchWeigher;
    private final ToLongFunction<A> longMatchWeigher;
    private final Function<A, BigDecimal> bigDecimalMatchWeigher;
    private BavetConstraint<Solution_> constraint;

    public BavetScoringUniConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractUniConstraintStream<Solution_, A> parent) {
        this(constraintFactory, parent, true, null, null, null);
    }

    public BavetScoringUniConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractUniConstraintStream<Solution_, A> parent, ToIntFunction<A> intMatchWeigher) {
        this(constraintFactory, parent, false, intMatchWeigher, null, null);
        if (intMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    public BavetScoringUniConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractUniConstraintStream<Solution_, A> parent, ToLongFunction<A> longMatchWeigher) {
        this(constraintFactory, parent, false, null, longMatchWeigher, null);
        if (longMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    public BavetScoringUniConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractUniConstraintStream<Solution_, A> parent, Function<A, BigDecimal> bigDecimalMatchWeigher) {
        this(constraintFactory, parent, false, null, null, bigDecimalMatchWeigher);
        if (bigDecimalMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    private BavetScoringUniConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractUniConstraintStream<Solution_, A> parent, boolean noMatchWeigher, ToIntFunction<A> intMatchWeigher, ToLongFunction<A> longMatchWeigher, Function<A, BigDecimal> bigDecimalMatchWeigher) {
        super(constraintFactory, parent.getRetrievalSemantics());
        this.parent = parent;
        this.noMatchWeigher = noMatchWeigher;
        this.intMatchWeigher = intMatchWeigher;
        this.longMatchWeigher = longMatchWeigher;
        this.bigDecimalMatchWeigher = bigDecimalMatchWeigher;
    }

    @Override
    public void setConstraint(BavetConstraint<Solution_> constraint) {
        this.constraint = constraint;
    }

    public boolean guaranteesDistinct() {
        return this.parent.guaranteesDistinct();
    }

    @Override
    public void collectActiveConstraintStreams(Set<BavetAbstractConstraintStream<Solution_>> constraintStreamSet) {
        this.parent.collectActiveConstraintStreams(constraintStreamSet);
        constraintStreamSet.add(this);
    }

    @Override
    public ConstraintStream getTupleSource() {
        return this.parent.getTupleSource();
    }

    @Override
    public <Score_ extends Score<Score_>> void buildNode(NodeBuildHelper<Score_> buildHelper) {
        Function<Object, UndoScoreImpacter> scoreImpacter;
        Score_ constraintWeight = buildHelper.getConstraintWeight((Constraint)this.constraint);
        AbstractScoreInliner<Score_> scoreInliner = buildHelper.getScoreInliner();
        if (!this.childStreamList.isEmpty()) {
            throw new IllegalStateException("Impossible state: the stream (" + this + ") has an non-empty childStreamList (" + this.childStreamList + ") but it's an endpoint.");
        }
        WeightedScoreImpacter weightedScoreImpacter = scoreInliner.buildWeightedScoreImpacter(this.constraint, constraintWeight);
        BiFunction justificationMapping = (BiFunction)this.constraint.getJustificationMapping();
        Function indictedObjectsMapping = (Function)this.constraint.getIndictedObjectsMapping();
        if (this.intMatchWeigher != null) {
            scoreImpacter = a -> {
                int matchWeight = this.intMatchWeigher.applyAsInt(a);
                this.constraint.assertCorrectImpact(matchWeight);
                return weightedScoreImpacter.impactScore(matchWeight, JustificationsSupplier.of(score -> (ConstraintJustification)justificationMapping.apply(a, score), () -> (Collection)indictedObjectsMapping.apply(a)));
            };
        } else if (this.longMatchWeigher != null) {
            scoreImpacter = a -> {
                long matchWeight = this.longMatchWeigher.applyAsLong(a);
                this.constraint.assertCorrectImpact(matchWeight);
                return weightedScoreImpacter.impactScore(matchWeight, JustificationsSupplier.of(score -> (ConstraintJustification)justificationMapping.apply(a, score), () -> (Collection)indictedObjectsMapping.apply(a)));
            };
        } else if (this.bigDecimalMatchWeigher != null) {
            scoreImpacter = a -> {
                BigDecimal matchWeight = this.bigDecimalMatchWeigher.apply(a);
                this.constraint.assertCorrectImpact(matchWeight);
                return weightedScoreImpacter.impactScore(matchWeight, JustificationsSupplier.of(score -> (ConstraintJustification)justificationMapping.apply(a, score), () -> (Collection)indictedObjectsMapping.apply(a)));
            };
        } else if (this.noMatchWeigher) {
            scoreImpacter = a -> weightedScoreImpacter.impactScore(1, JustificationsSupplier.of(score -> (ConstraintJustification)justificationMapping.apply(a, score), () -> (Collection)indictedObjectsMapping.apply(a)));
        } else {
            throw new IllegalStateException("Impossible state: neither of the supported match weighers provided.");
        }
        UniScorer<Object> scorer = new UniScorer<Object>(this.constraint.getConstraintPackage(), this.constraint.getConstraintName(), (Score<?>)constraintWeight, scoreImpacter, buildHelper.reserveTupleStoreIndex(this.parent.getTupleSource()));
        buildHelper.putInsertUpdateRetract((ConstraintStream)this, scorer);
    }

    public String toString() {
        return "Scoring(" + this.constraint.getConstraintName() + ")";
    }
}

