/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.client.json;

import org.apache.http.client.HttpClient;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.bimserver.client.json.JsonReflectorFactory;
import org.bimserver.shared.TokenHolder;
import org.bimserver.shared.json.JsonSocketReflector;
import org.bimserver.shared.meta.SServicesMap;

public class JsonSocketReflectorFactory
implements JsonReflectorFactory {
    private SServicesMap servicesMap;
    private CloseableHttpClient httpclient;
    private PoolingHttpClientConnectionManager poolingHttpClientConnectionManager;

    public JsonSocketReflectorFactory(SServicesMap servicesMap) {
        if (servicesMap == null) {
            throw new IllegalArgumentException("servicesMap cannot be null");
        }
        this.servicesMap = servicesMap;
        this.poolingHttpClientConnectionManager = new PoolingHttpClientConnectionManager();
        this.poolingHttpClientConnectionManager.setDefaultMaxPerRoute(5);
        this.poolingHttpClientConnectionManager.setMaxTotal(20);
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        httpClientBuilder.setConnectionManager((HttpClientConnectionManager)this.poolingHttpClientConnectionManager);
        this.httpclient = httpClientBuilder.build();
    }

    public void close() {
        this.poolingHttpClientConnectionManager.shutdown();
    }

    public JsonSocketReflector create(String remoteAddress, TokenHolder tokenHolder) {
        return new JsonSocketReflector((HttpClient)this.httpclient, this.servicesMap, remoteAddress, tokenHolder);
    }
}

