/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.tool.merge;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.time.LocalDate;
import java.util.ArrayList;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.ofdrw.core.basicStructure.doc.Document;
import org.ofdrw.core.basicStructure.ofd.DocBody;
import org.ofdrw.core.basicStructure.ofd.OFD;
import org.ofdrw.core.basicStructure.ofd.docInfo.CT_DocInfo;
import org.ofdrw.core.basicStructure.pageTree.Page;
import org.ofdrw.core.basicStructure.pageTree.Pages;
import org.ofdrw.core.basicType.ST_Loc;
import org.ofdrw.pkg.container.OFDDir;
import org.ofdrw.reader.OFDReader;
import org.ofdrw.reader.ResourceLocator;

public class OFDPageDeleter
implements Closeable {
    private final OFDDir ofdDir;
    private final OFD ofd;
    private final Document ofdRoot;
    private final OFDReader reader;
    private final Path outPath;

    public OFDPageDeleter(Path src, Path out) throws IOException, DocumentException {
        if (src == null || !src.toFile().exists()) {
            throw new IllegalArgumentException("OFD\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        if (out == null) {
            throw new IllegalArgumentException("\u8f93\u51fa\u8def\u5f84\uff08out\uff09\u4e3a\u7a7a");
        }
        this.reader = new OFDReader(src);
        this.outPath = out;
        this.ofdDir = this.reader.getOFDDir();
        this.ofd = this.ofdDir.getOfd();
        ResourceLocator rl = this.reader.getResourceLocator();
        DocBody docBody = this.ofd.getDocBody();
        ST_Loc docRoot = docBody.getDocRoot();
        this.ofdRoot = (Document)rl.get(docRoot, Document::new);
    }

    public OFDPageDeleter delete(int ... indexes) {
        if (indexes == null || indexes.length == 0) {
            return this;
        }
        Pages pages = this.ofdRoot.getPages();
        ArrayList<Page> tbd = new ArrayList<Page>();
        for (int index : indexes) {
            for (int i = 0; i < pages.getPages().size(); ++i) {
                if (i != index) continue;
                tbd.add(pages.getPageByIndex(i));
            }
        }
        Object object = tbd.iterator();
        while (object.hasNext()) {
            Page page = (Page)object.next();
            pages.remove((Element)page);
        }
        return this;
    }

    @Override
    public void close() throws IOException {
        DocBody docBody = this.ofd.getDocBody();
        CT_DocInfo docInfo = docBody.getDocInfo();
        docInfo.setModDate(LocalDate.now());
        if (this.outPath != null) {
            this.ofdDir.jar(this.outPath.toAbsolutePath());
        }
        if (this.reader != null) {
            this.reader.close();
        }
    }
}

