/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.sign;

import java.util.concurrent.atomic.AtomicInteger;
import org.ofdrw.sign.SignIDProvider;

public class NumberFormatAtomicSignID
implements SignIDProvider {
    private final AtomicInteger provider;
    private boolean enableZeroPrefix = false;

    public NumberFormatAtomicSignID() {
        this.provider = new AtomicInteger(0);
    }

    public NumberFormatAtomicSignID(boolean enableZeroPrefix) {
        this.provider = new AtomicInteger(0);
        this.enableZeroPrefix = enableZeroPrefix;
    }

    public NumberFormatAtomicSignID(String maxSignID) {
        int maxSignIDNum = this.parse(maxSignID);
        this.provider = new AtomicInteger(maxSignIDNum);
    }

    @Override
    public void setCurrentMaxSignId(String maxSignId) {
        int maxSignIDNum = this.parse(maxSignId);
        this.provider.set(maxSignIDNum);
    }

    @Override
    public String incrementAndGet() {
        int newSignID = this.provider.incrementAndGet();
        if (this.enableZeroPrefix) {
            return String.format("%03d", newSignID);
        }
        return String.valueOf(newSignID);
    }

    @Override
    public String get() {
        int maxSignId = this.provider.get();
        if (this.enableZeroPrefix) {
            return String.format("%03d", maxSignId);
        }
        return String.valueOf(maxSignId);
    }

    @Override
    public int parse(String id) {
        return Integer.parseInt(id);
    }

    public void setEnableZeroPrefix(boolean enableZeroPrefix) {
        this.enableZeroPrefix = enableZeroPrefix;
    }

    public boolean isEnableZeroPrefix() {
        return this.enableZeroPrefix;
    }
}

