/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.sign.signContainer;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Signature;
import java.security.cert.Certificate;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.jcajce.provider.digest.SM3;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.ofdrw.core.signatures.SigType;
import org.ofdrw.gm.ses.v1.SES_Header;
import org.ofdrw.gm.ses.v4.SES_Signature;
import org.ofdrw.gm.ses.v4.SESeal;
import org.ofdrw.gm.ses.v4.TBS_Sign;
import org.ofdrw.sign.ExtendSignatureContainer;

public class SESV4Container
implements ExtendSignatureContainer {
    private final PrivateKey privateKey;
    private final SESeal seal;
    private final Certificate certificate;

    public SESV4Container(PrivateKey privateKey, SESeal seal, Certificate signCert) {
        this.privateKey = privateKey;
        this.seal = seal;
        this.certificate = signCert;
    }

    @Override
    public MessageDigest getDigestFnc() {
        return new SM3.Digest();
    }

    @Override
    public ASN1ObjectIdentifier getSignAlgOID() {
        return GMObjectIdentifiers.sm2sign_with_sm3;
    }

    @Override
    public byte[] sign(InputStream inData, String propertyInfo) throws IOException, GeneralSecurityException {
        MessageDigest md = this.getDigestFnc();
        byte[] dataHash = md.digest(IOUtils.toByteArray((InputStream)inData));
        TBS_Sign toSign = new TBS_Sign().setVersion(SES_Header.V4).setEseal(this.seal).setTimeInfo(new ASN1GeneralizedTime(new Date())).setDataHash(dataHash).setPropertyInfo(propertyInfo);
        Signature sg = Signature.getInstance("SM3WithSM2", (Provider)new BouncyCastleProvider());
        sg.initSign(this.privateKey);
        sg.update(toSign.getEncoded("DER"));
        byte[] sigVal = sg.sign();
        SES_Signature signature = new SES_Signature().setToSign(toSign).setCert(this.certificate).setSignatureAlgID(GMObjectIdentifiers.sm2sign_with_sm3).setSignature(sigVal);
        return signature.getEncoded("DER");
    }

    @Override
    public byte[] getSeal() throws IOException {
        return this.seal.getEncoded("DER");
    }

    @Override
    public SigType getSignType() {
        return SigType.Seal;
    }
}

