/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.graphics2d;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.io.Serializable;
import org.ofdrw.core.basicType.ST_Array;
import org.ofdrw.core.basicType.ST_Box;
import org.ofdrw.core.basicType.ST_Pos;
import org.ofdrw.core.basicType.ST_RefID;
import org.ofdrw.core.pageDescription.CT_GraphicUnit;
import org.ofdrw.core.pageDescription.color.color.CT_AxialShd;
import org.ofdrw.core.pageDescription.color.color.CT_Color;
import org.ofdrw.core.pageDescription.color.color.CT_RadialShd;
import org.ofdrw.core.pageDescription.color.color.ColorClusterType;
import org.ofdrw.core.pageDescription.color.color.MapType;
import org.ofdrw.core.pageDescription.color.color.Segment;
import org.ofdrw.core.pageDescription.drawParam.CT_DrawParam;
import org.ofdrw.core.pageDescription.drawParam.LineCapType;
import org.ofdrw.core.pageDescription.drawParam.LineJoinType;
import org.ofdrw.graphics2d.OFDGraphicsDocument;

public class OFDGraphics2DDrawParam {
    private final OFDGraphicsDocument docCtx;
    ST_Box area;
    Font font;
    ST_RefID ref;
    BasicStroke gStroke;
    Paint gColor;
    Area clip;
    AffineTransform ctm;
    Color gBackground;
    Color gForeground;
    RenderingHints hints;
    Composite composite;
    FontRenderContext fontRenderCtx;

    public OFDGraphics2DDrawParam(OFDGraphicsDocument docCtx, ST_Box area) {
        this.docCtx = docCtx;
        this.gStroke = new BasicStroke(0.353f);
        this.gColor = new Color(0, 0, 0);
        this.gBackground = new Color(255, 255, 255);
        this.gForeground = new Color(0, 0, 0);
        this.ctm = new AffineTransform();
        this.ref = null;
        this.clip = null;
        this.hints = new RenderingHints(null);
        this.composite = AlphaComposite.SrcOver;
        this.font = new Font("sanserif", 0, 3);
        if (area != null) {
            this.area = area.clone();
        }
    }

    @Deprecated
    public OFDGraphics2DDrawParam(OFDGraphicsDocument docCtx) {
        this(docCtx, new ST_Box(0.0, 0.0, 210.0, 297.0));
    }

    ST_RefID makeDrawParam() {
        if (this.ref != null) {
            return this.ref;
        }
        CT_DrawParam param = new CT_DrawParam();
        this.setStrokeParam(param);
        this.setColorParam(param);
        double lineWidth = this.gStroke.getLineWidth();
        double scale = 1.0;
        if (!this.ctm.isIdentity()) {
            scale = Math.min(Math.abs(this.ctm.getScaleX()), Math.abs(this.ctm.getScaleY()));
        }
        param.setLineWidth(Double.valueOf(lineWidth * scale));
        this.ref = this.docCtx.addDrawParam(param).ref();
        return this.ref;
    }

    private void setColorParam(CT_DrawParam param) {
        CT_Color ctColor = null;
        if (this.gColor instanceof Color) {
            Color c = (Color)this.gColor;
            ctColor = CT_Color.rgb((int)c.getRed(), (int)c.getGreen(), (int)c.getBlue());
            int alpha = c.getAlpha();
            if (alpha != 255) {
                ctColor.setAlpha(Integer.valueOf(alpha));
            }
        } else if (this.gColor instanceof LinearGradientPaint) {
            LinearGradientPaint lgp = (LinearGradientPaint)this.gColor;
            ctColor = new CT_Color();
            CT_AxialShd axialShd = new CT_AxialShd();
            axialShd.setStartPoint(ST_Pos.getInstance((double)lgp.getStartPoint().getX(), (double)lgp.getStartPoint().getY()));
            axialShd.setEndPoint(ST_Pos.getInstance((double)lgp.getEndPoint().getX(), (double)lgp.getEndPoint().getY()));
            Color[] colors = lgp.getColors();
            float[] fractions = lgp.getFractions();
            for (int i = 0; i < colors.length; ++i) {
                CT_Color cc = CT_Color.rgb((int)colors[i].getRed(), (int)colors[i].getGreen(), (int)colors[i].getBlue());
                int alpha = colors[i].getAlpha();
                if (alpha != 255) {
                    cc.setAlpha(Integer.valueOf(alpha));
                }
                axialShd.addSegment(new Segment(Double.valueOf(fractions[i]), cc));
            }
            switch (lgp.getCycleMethod()) {
                case NO_CYCLE: {
                    axialShd.setMapType(MapType.Direct);
                    break;
                }
                case REPEAT: {
                    axialShd.setMapType(MapType.Repeat);
                    break;
                }
                case REFLECT: {
                    axialShd.setMapType(MapType.Reflect);
                }
            }
            ctColor.setColor((ColorClusterType)axialShd);
        } else if (this.gColor instanceof RadialGradientPaint) {
            RadialGradientPaint rgp = (RadialGradientPaint)this.gColor;
            ctColor = new CT_Color();
            CT_RadialShd radialShd = new CT_RadialShd();
            Color[] colors = rgp.getColors();
            float[] fractions = rgp.getFractions();
            for (int i = 0; i < colors.length; ++i) {
                CT_Color cc = CT_Color.rgb((int)colors[i].getRed(), (int)colors[i].getGreen(), (int)colors[i].getBlue());
                int alpha = colors[i].getAlpha();
                if (alpha != 255) {
                    cc.setAlpha(Integer.valueOf(alpha));
                }
                radialShd.addSegment(new Segment(Double.valueOf(fractions[i]), cc));
            }
            switch (rgp.getCycleMethod()) {
                case NO_CYCLE: {
                    radialShd.setMapType(MapType.Direct);
                    break;
                }
                case REFLECT: {
                    radialShd.setMapType(MapType.Reflect);
                    break;
                }
                case REPEAT: {
                    radialShd.setMapType(MapType.Repeat);
                }
            }
            radialShd.setEndRadius(Double.valueOf(rgp.getRadius()));
            ST_Pos startPoint = ST_Pos.getInstance((double)rgp.getCenterPoint().getX(), (double)rgp.getCenterPoint().getY());
            radialShd.setStartPoint(startPoint);
            ST_Pos endPoint = ST_Pos.getInstance((double)rgp.getFocusPoint().getX(), (double)rgp.getFocusPoint().getY());
            radialShd.setEndPoint(endPoint);
            ctColor.setColor((ColorClusterType)radialShd);
        } else if (this.gColor instanceof GradientPaint) {
            GradientPaint gp = (GradientPaint)this.gColor;
            ctColor = new CT_Color();
            CT_AxialShd axialShd = new CT_AxialShd();
            axialShd.setStartPoint(ST_Pos.getInstance((double)gp.getPoint1().getX(), (double)gp.getPoint1().getY()));
            axialShd.setEndPoint(ST_Pos.getInstance((double)gp.getPoint2().getX(), (double)gp.getPoint2().getY()));
            if (gp.isCyclic()) {
                axialShd.setMapType(MapType.Repeat);
            }
            axialShd.addSegment(new Segment(CT_Color.rgb((int)gp.getColor1().getRed(), (int)gp.getColor1().getGreen(), (int)gp.getColor1().getBlue())));
            axialShd.addSegment(new Segment(CT_Color.rgb((int)gp.getColor2().getRed(), (int)gp.getColor2().getGreen(), (int)gp.getColor2().getBlue())));
            ctColor.setColor((ColorClusterType)axialShd);
        }
        if (ctColor != null) {
            param.setFillColor(ctColor);
            param.setStrokeColor(ctColor);
        }
    }

    private void setStrokeParam(CT_DrawParam param) {
        float[] dashArray;
        switch (this.gStroke.getLineJoin()) {
            case 2: {
                param.setJoin(LineJoinType.Bevel);
                break;
            }
            case 0: {
                param.setJoin(LineJoinType.Miter);
                break;
            }
            case 1: {
                param.setJoin(LineJoinType.Round);
                break;
            }
            default: {
                param.setJoin(null);
            }
        }
        if (this.gStroke.getLineWidth() > 0.0f) {
            param.setLineWidth(Double.valueOf(this.gStroke.getLineWidth()));
        }
        if ((dashArray = this.gStroke.getDashArray()) != null && dashArray.length > 0) {
            ST_Array pattern = new ST_Array(new Serializable[0]);
            for (float v : dashArray) {
                pattern.add(Float.toString(v));
            }
            param.setDashPattern(pattern);
        } else {
            param.setDashPattern(null);
        }
        switch (this.gStroke.getEndCap()) {
            case 0: {
                param.setCap(LineCapType.Butt);
                break;
            }
            case 1: {
                param.setCap(LineCapType.Round);
                break;
            }
            case 2: {
                param.setCap(LineCapType.Square);
                break;
            }
            default: {
                param.setCap(null);
            }
        }
        float miterLimit = this.gStroke.getMiterLimit();
        if (miterLimit > 0.0f) {
            param.setMiterLimit(Double.valueOf(miterLimit));
        } else {
            param.setMiterLimit(null);
        }
    }

    public void setStroke(Stroke s) {
        this.ref = null;
        if (s == null) {
            s = new BasicStroke(0.353f);
        }
        if (s instanceof BasicStroke) {
            this.gStroke = (BasicStroke)s;
        }
    }

    public void setColor(Paint paint) {
        if (this.gColor == paint) {
            return;
        }
        this.ref = null;
        if (paint == null) {
            paint = new Color(0, 0, 0);
        }
        this.gColor = paint;
    }

    public void setForeground(Color c) {
        this.gForeground = c;
        this.setColor(c);
    }

    @Deprecated
    public void apply(CT_GraphicUnit<?> target) {
    }

    public FontRenderContext getFontRenderContext() {
        if (this.fontRenderCtx != null) {
            return this.fontRenderCtx;
        }
        Object antialiasingHint = this.hints.get(RenderingHints.KEY_TEXT_ANTIALIASING);
        boolean isAntialiased = true;
        if (antialiasingHint != RenderingHints.VALUE_TEXT_ANTIALIAS_ON && antialiasingHint != RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT) {
            if (antialiasingHint != RenderingHints.VALUE_TEXT_ANTIALIAS_OFF) {
                antialiasingHint = this.hints.get(RenderingHints.KEY_ANTIALIASING);
                if (antialiasingHint != RenderingHints.VALUE_ANTIALIAS_ON && antialiasingHint != RenderingHints.VALUE_ANTIALIAS_DEFAULT && antialiasingHint == RenderingHints.VALUE_ANTIALIAS_OFF) {
                    isAntialiased = false;
                }
            } else {
                isAntialiased = false;
            }
        }
        boolean useFractionalMetrics = this.hints.get(RenderingHints.KEY_FRACTIONALMETRICS) != RenderingHints.VALUE_FRACTIONALMETRICS_OFF;
        this.fontRenderCtx = new FontRenderContext(new AffineTransform(), isAntialiased, useFractionalMetrics);
        return this.fontRenderCtx;
    }

    public OFDGraphics2DDrawParam clone() {
        OFDGraphics2DDrawParam that = new OFDGraphics2DDrawParam(this.docCtx, this.area);
        that.gColor = this.gColor;
        that.gStroke = this.gStroke;
        that.gBackground = this.gBackground;
        that.gForeground = this.gForeground;
        that.ctm = new AffineTransform(this.ctm);
        that.clip = this.clip;
        that.ref = this.ref;
        that.hints = (RenderingHints)this.hints.clone();
        that.composite = this.composite;
        that.font = this.font;
        return that;
    }

    public static ST_Array trans(AffineTransform tx) {
        return new ST_Array(tx.getScaleX(), tx.getShearY(), tx.getShearX(), tx.getScaleY(), tx.getTranslateX(), tx.getTranslateY());
    }
}

