/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font;

import com.itextpdf.io.font.OpenTypeParser;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

class ItextOpenTypeParser
extends OpenTypeParser
implements Serializable,
Closeable {
    private static final long serialVersionUID = 3399061674525229738L;

    public ItextOpenTypeParser(byte[] ttf) throws IOException {
        super(ttf);
    }

    public ItextOpenTypeParser(byte[] ttc, int ttcIndex) throws IOException {
        super(ttc, ttcIndex);
    }

    public ItextOpenTypeParser(String ttcPath, int ttcIndex) throws IOException {
        super(ttcPath, ttcIndex);
    }

    public ItextOpenTypeParser(String name) throws IOException {
        super(name);
    }

    public String getPsFontName() {
        try {
            return super.getPsFontName();
        }
        catch (Exception e) {
            return "Font";
        }
    }

    protected void loadTables(boolean all) throws IOException {
        this.readNameTable();
        this.readHeadTable();
        this.readOs_2Table();
        this.readPostTable();
        if (all) {
            this.checkCff();
            this.readHheaTable();
            this.readGlyphWidths();
            this.readCmapTable();
        }
    }

    private void readNameTable() throws IOException {
        int[] table_location = (int[])this.tables.get("name");
        if (table_location == null) {
            // empty if block
        }
        this.allNameEntries = new LinkedHashMap();
        if (table_location != null) {
            this.raf.seek((long)(table_location[0] + 2));
        }
        int numRecords = this.raf.readUnsignedShort();
        int startOfStorage = this.raf.readUnsignedShort();
        for (int k = 0; k < numRecords; ++k) {
            ArrayList<String[]> names;
            int platformID = this.raf.readUnsignedShort();
            int platformEncodingID = this.raf.readUnsignedShort();
            int languageID = this.raf.readUnsignedShort();
            int nameID = this.raf.readUnsignedShort();
            int length = this.raf.readUnsignedShort();
            int offset = this.raf.readUnsignedShort();
            if (this.allNameEntries.containsKey(nameID)) {
                names = (ArrayList<String[]>)this.allNameEntries.get(nameID);
            } else {
                names = new ArrayList<String[]>();
                this.allNameEntries.put(nameID, names);
            }
            int pos = (int)this.raf.getPosition();
            if (table_location != null) {
                this.raf.seek((long)(table_location[0] + startOfStorage + offset));
            }
            String name = platformID == 0 || platformID == 3 || platformID == 2 && platformEncodingID == 1 ? this.readUnicodeString(length) : this.readStandardString(length);
            names.add(new String[]{Integer.toString(platformID), Integer.toString(platformEncodingID), Integer.toString(languageID), name});
            this.raf.seek((long)pos);
        }
    }

    private void readHheaTable() throws IOException {
        int[] table_location = (int[])this.tables.get("hhea");
        if (table_location == null) {
            if (this.fileName != null) {
                throw new IOException("hhea table does not exist in " + this.fileName);
            }
            throw new IOException("hhea table does not exist");
        }
        this.raf.seek((long)(table_location[0] + 4));
        this.hhea = new OpenTypeParser.HorizontalHeader();
        this.hhea.Ascender = this.raf.readShort();
        this.hhea.Descender = this.raf.readShort();
        this.hhea.LineGap = this.raf.readShort();
        this.hhea.advanceWidthMax = this.raf.readUnsignedShort();
        this.hhea.minLeftSideBearing = this.raf.readShort();
        this.hhea.minRightSideBearing = this.raf.readShort();
        this.hhea.xMaxExtent = this.raf.readShort();
        this.hhea.caretSlopeRise = this.raf.readShort();
        this.hhea.caretSlopeRun = this.raf.readShort();
        this.raf.skipBytes(12);
        this.hhea.numberOfHMetrics = this.raf.readUnsignedShort();
    }

    private void readHeadTable() throws IOException {
        int[] table_location = (int[])this.tables.get("head");
        if (table_location == null) {
            if (this.fileName != null) {
                throw new IOException("head table does not exist in " + this.fileName);
            }
            throw new IOException("head table does not exist");
        }
        this.raf.seek((long)(table_location[0] + 16));
        this.head = new OpenTypeParser.HeaderTable();
        this.head.flags = this.raf.readUnsignedShort();
        this.head.unitsPerEm = this.raf.readUnsignedShort();
        this.raf.skipBytes(16);
        this.head.xMin = this.raf.readShort();
        this.head.yMin = this.raf.readShort();
        this.head.xMax = this.raf.readShort();
        this.head.yMax = this.raf.readShort();
        this.head.macStyle = this.raf.readUnsignedShort();
    }

    private void readOs_2Table() throws IOException {
        int[] table_location = (int[])this.tables.get("OS/2");
        if (table_location == null) {
            table_location = (int[])this.tables.get("os/2");
        }
        if (table_location == null) {
            if (this.fileName != null) {
                throw new IOException("OS/2 table does not exist in " + this.fileName);
            }
            throw new IOException("OS/2 table does not exist");
        }
        this.os_2 = new OpenTypeParser.WindowsMetrics();
        this.raf.seek((long)table_location[0]);
        int version = this.raf.readUnsignedShort();
        this.os_2.xAvgCharWidth = this.raf.readShort();
        this.os_2.usWeightClass = this.raf.readUnsignedShort();
        this.os_2.usWidthClass = this.raf.readUnsignedShort();
        this.os_2.fsType = this.raf.readShort();
        this.os_2.ySubscriptXSize = this.raf.readShort();
        this.os_2.ySubscriptYSize = this.raf.readShort();
        this.os_2.ySubscriptXOffset = this.raf.readShort();
        this.os_2.ySubscriptYOffset = this.raf.readShort();
        this.os_2.ySuperscriptXSize = this.raf.readShort();
        this.os_2.ySuperscriptYSize = this.raf.readShort();
        this.os_2.ySuperscriptXOffset = this.raf.readShort();
        this.os_2.ySuperscriptYOffset = this.raf.readShort();
        this.os_2.yStrikeoutSize = this.raf.readShort();
        this.os_2.yStrikeoutPosition = this.raf.readShort();
        this.os_2.sFamilyClass = this.raf.readShort();
        this.raf.readFully(this.os_2.panose);
        this.raf.skipBytes(16);
        this.raf.readFully(this.os_2.achVendID);
        this.os_2.fsSelection = this.raf.readUnsignedShort();
        this.os_2.usFirstCharIndex = this.raf.readUnsignedShort();
        this.os_2.usLastCharIndex = this.raf.readUnsignedShort();
        this.os_2.sTypoAscender = this.raf.readShort();
        this.os_2.sTypoDescender = this.raf.readShort();
        if (this.os_2.sTypoDescender > 0) {
            this.os_2.sTypoDescender = -this.os_2.sTypoDescender;
        }
        this.os_2.sTypoLineGap = this.raf.readShort();
        this.os_2.usWinAscent = this.raf.readUnsignedShort();
        this.os_2.usWinDescent = this.raf.readUnsignedShort();
        if (this.os_2.usWinDescent > 0) {
            this.os_2.usWinDescent = (short)(-this.os_2.usWinDescent);
        }
        this.os_2.ulCodePageRange1 = 0;
        this.os_2.ulCodePageRange2 = 0;
        if (version > 0) {
            this.os_2.ulCodePageRange1 = this.raf.readInt();
            this.os_2.ulCodePageRange2 = this.raf.readInt();
        }
        if (version > 1) {
            this.raf.skipBytes(2);
            this.os_2.sCapHeight = this.raf.readShort();
        } else {
            this.os_2.sCapHeight = (int)(0.7 * (double)this.head.unitsPerEm);
        }
    }

    private void readPostTable() throws IOException {
        int[] table_location = (int[])this.tables.get("post");
        if (table_location != null) {
            this.raf.seek((long)(table_location[0] + 4));
            short mantissa = this.raf.readShort();
            int fraction = this.raf.readUnsignedShort();
            this.post = new OpenTypeParser.PostTable();
            this.post.italicAngle = (float)((double)mantissa + (double)fraction / 16384.0);
            this.post.underlinePosition = this.raf.readShort();
            this.post.underlineThickness = this.raf.readShort();
            this.post.isFixedPitch = this.raf.readInt() != 0;
        } else {
            this.post = new OpenTypeParser.PostTable();
            if (null != this.hhea) {
                this.post.italicAngle = (float)(-Math.atan2(this.hhea.caretSlopeRun, this.hhea.caretSlopeRise) * 180.0 / Math.PI);
            }
        }
    }

    private void readCmapTable() throws IOException {
        int format;
        int[] table_location = (int[])this.tables.get("cmap");
        if (table_location != null) {
            this.raf.seek((long)table_location[0]);
        }
        this.raf.skipBytes(2);
        int num_tables = this.raf.readUnsignedShort();
        int map10 = 0;
        int map31 = 0;
        int map30 = 0;
        int mapExt = 0;
        this.cmaps = new OpenTypeParser.CmapTable();
        for (int k = 0; k < num_tables; ++k) {
            int platId = this.raf.readUnsignedShort();
            int platSpecId = this.raf.readUnsignedShort();
            int offset = this.raf.readInt();
            if (platId == 3 && platSpecId == 0) {
                this.cmaps.fontSpecific = true;
                map30 = offset;
                continue;
            }
            if (platId == 3 && platSpecId == 1) {
                map31 = offset;
                continue;
            }
            if (platId == 3 && platSpecId == 10) {
                mapExt = offset;
                continue;
            }
            if (platId != 1 || platSpecId != 0) continue;
            map10 = offset;
        }
        if (map10 > 0) {
            this.raf.seek((long)(table_location[0] + map10));
            format = this.raf.readUnsignedShort();
            switch (format) {
                case 0: {
                    this.cmaps.cmap10 = this.readFormat0();
                    break;
                }
                case 4: {
                    this.cmaps.cmap10 = this.readFormat4(false);
                    break;
                }
                case 6: {
                    this.cmaps.cmap10 = this.readFormat6();
                }
            }
        }
        if (map31 > 0) {
            this.raf.seek((long)(table_location[0] + map31));
            format = this.raf.readUnsignedShort();
            if (format == 4) {
                this.cmaps.cmap31 = this.readFormat4(false);
            }
        }
        if (map30 > 0) {
            this.raf.seek((long)(table_location[0] + map30));
            format = this.raf.readUnsignedShort();
            if (format == 4) {
                this.cmaps.cmap10 = this.readFormat4(this.cmaps.fontSpecific);
            } else {
                this.cmaps.fontSpecific = false;
            }
        }
        if (mapExt > 0) {
            this.raf.seek((long)(table_location[0] + mapExt));
            format = this.raf.readUnsignedShort();
            switch (format) {
                case 0: {
                    this.cmaps.cmapExt = this.readFormat0();
                    break;
                }
                case 4: {
                    this.cmaps.cmapExt = this.readFormat4(false);
                    break;
                }
                case 6: {
                    this.cmaps.cmapExt = this.readFormat6();
                    break;
                }
                case 12: {
                    this.cmaps.cmapExt = this.readFormat12();
                }
            }
        }
        if (null == this.cmaps.cmapExt && null == this.cmaps.cmap31 && null == this.cmaps.cmap10) {
            this.cmaps.cmap10 = new HashMap();
        }
    }

    private String readStandardString(int length) throws IOException {
        return this.raf.readString(length, "Cp1252");
    }

    private String readUnicodeString(int length) throws IOException {
        StringBuilder buf = new StringBuilder();
        length /= 2;
        for (int k = 0; k < length; ++k) {
            buf.append(this.raf.readChar());
        }
        return buf.toString();
    }

    private Map<Integer, int[]> readFormat0() throws IOException {
        LinkedHashMap<Integer, int[]> h = new LinkedHashMap<Integer, int[]>();
        this.raf.skipBytes(4);
        for (int k = 0; k < 256; ++k) {
            int[] r;
            r = new int[]{this.raf.readUnsignedByte(), this.getGlyphWidth(r[0])};
            h.put(k, r);
        }
        return h;
    }

    private Map<Integer, int[]> readFormat4(boolean fontSpecific) throws IOException {
        int k;
        LinkedHashMap<Integer, int[]> h = new LinkedHashMap<Integer, int[]>();
        int table_lenght = this.raf.readUnsignedShort();
        this.raf.skipBytes(2);
        int segCount = this.raf.readUnsignedShort() / 2;
        this.raf.skipBytes(6);
        int[] endCount = new int[segCount];
        for (int k2 = 0; k2 < segCount; ++k2) {
            endCount[k2] = this.raf.readUnsignedShort();
        }
        this.raf.skipBytes(2);
        int[] startCount = new int[segCount];
        for (int k3 = 0; k3 < segCount; ++k3) {
            startCount[k3] = this.raf.readUnsignedShort();
        }
        int[] idDelta = new int[segCount];
        for (int k4 = 0; k4 < segCount; ++k4) {
            idDelta[k4] = this.raf.readUnsignedShort();
        }
        int[] idRO = new int[segCount];
        for (int k5 = 0; k5 < segCount; ++k5) {
            idRO[k5] = this.raf.readUnsignedShort();
        }
        int[] glyphId = new int[table_lenght / 2 - 8 - segCount * 4];
        for (k = 0; k < glyphId.length; ++k) {
            glyphId[k] = this.raf.readUnsignedShort();
        }
        for (k = 0; k < segCount; ++k) {
            for (int j = startCount[k]; j <= endCount[k] && j != 65535; ++j) {
                int[] r;
                int glyph;
                if (idRO[k] == 0) {
                    glyph = j + idDelta[k] & 0xFFFF;
                } else {
                    int idx = k + idRO[k] / 2 - segCount + j - startCount[k];
                    if (idx >= glyphId.length) continue;
                    glyph = glyphId[idx] + idDelta[k] & 0xFFFF;
                }
                r = new int[]{glyph, this.getGlyphWidth(r[0])};
                if (fontSpecific && (j & 0xFF00) == 61440) {
                    h.put(j & 0xFF, r);
                }
                h.put(j, r);
            }
        }
        return h;
    }

    private Map<Integer, int[]> readFormat6() throws IOException {
        LinkedHashMap<Integer, int[]> h = new LinkedHashMap<Integer, int[]>();
        this.raf.skipBytes(4);
        int start_code = this.raf.readUnsignedShort();
        int code_count = this.raf.readUnsignedShort();
        for (int k = 0; k < code_count; ++k) {
            int[] r;
            r = new int[]{this.raf.readUnsignedShort(), this.getGlyphWidth(r[0])};
            h.put(k + start_code, r);
        }
        return h;
    }

    private Map<Integer, int[]> readFormat12() throws IOException {
        LinkedHashMap<Integer, int[]> h = new LinkedHashMap<Integer, int[]>();
        this.raf.skipBytes(2);
        int table_length = this.raf.readInt();
        this.raf.skipBytes(4);
        int nGroups = this.raf.readInt();
        for (int k = 0; k < nGroups; ++k) {
            int startCharCode = this.raf.readInt();
            int endCharCode = this.raf.readInt();
            int startGlyphID = this.raf.readInt();
            for (int i = startCharCode; i <= endCharCode; ++i) {
                int[] r;
                r = new int[]{startGlyphID++, this.getGlyphWidth(r[0])};
                h.put(i, r);
            }
        }
        return h;
    }
}

