/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.converter.ofdconverter;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pdfbox.cos.COSInputStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDNameTreeNode;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.apache.pdfbox.pdmodel.common.filespecification.PDFileSpecification;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionGoTo;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationFileAttachment;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDNamedDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageFitHeightDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageFitRectangleDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageFitWidthDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageXYZDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineNode;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.ofdrw.converter.GeneralConvertException;
import org.ofdrw.converter.ofdconverter.DocConverter;
import org.ofdrw.core.action.actionType.actionGoto.CT_Dest;
import org.ofdrw.core.action.actionType.actionGoto.DestType;
import org.ofdrw.core.attachment.CT_Attachment;
import org.ofdrw.core.basicStructure.doc.bookmark.Bookmark;
import org.ofdrw.core.basicStructure.doc.bookmark.Bookmarks;
import org.ofdrw.core.basicType.ST_ID;
import org.ofdrw.graphics2d.OFDGraphicsDocument;
import org.ofdrw.graphics2d.OFDPageGraphics2D;

public class PDFConverter
implements DocConverter {
    private boolean closed = false;
    final OFDGraphicsDocument ofdDoc;
    private Bookmarks bookmarks;
    double uuPmm = 2.8346;
    private final Set<String> copied;
    private boolean enableCopyAttachFiles;
    private boolean enableCopyBookmarks;

    public PDFConverter(Path ofdPath) throws IOException {
        if (ofdPath == null) {
            throw new IllegalArgumentException("\u8f6c\u6362\u540e\u7684OFD\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
        }
        if (!Files.exists(ofdPath = ofdPath.toAbsolutePath(), new LinkOption[0])) {
            Path parent = ofdPath.getParent();
            if (Files.exists(parent, new LinkOption[0])) {
                if (!Files.isDirectory(parent, new LinkOption[0])) {
                    throw new IllegalArgumentException("\u5df2\u7ecf\u5b58\u5728\u540c\u540d\u6587\u4ef6: " + parent);
                }
            } else {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            Files.createFile(ofdPath, new FileAttribute[0]);
        }
        this.ofdDoc = new OFDGraphicsDocument(ofdPath);
        this.copied = new HashSet<String>();
        this.enableCopyAttachFiles = true;
        this.enableCopyBookmarks = true;
        this.bookmarks = null;
    }

    @Override
    public void convert(Path filepath, int ... indexes) throws GeneralConvertException {
        if (filepath == null || !Files.exists(filepath, new LinkOption[0]) || Files.isDirectory(filepath, new LinkOption[0])) {
            return;
        }
        try (PDDocument pdfDoc = PDDocument.load((File)filepath.toFile());){
            int total = pdfDoc.getNumberOfPages();
            LinkedList<Integer> targetPages = new LinkedList<Integer>();
            if (indexes == null || indexes.length == 0) {
                for (int i = 0; i < total; ++i) {
                    targetPages.add(i);
                }
            } else {
                for (int index : indexes) {
                    if (index < 0 || index >= total) continue;
                    targetPages.add(index);
                }
            }
            PDFRenderer pdfRender = new PDFRenderer(pdfDoc);
            RenderingHints r = new RenderingHints(null);
            r.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            r.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            r.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            pdfRender.setRenderingHints(r);
            PDDocumentOutline pdfOutline = pdfDoc.getDocumentCatalog().getDocumentOutline();
            for (Integer index : targetPages) {
                PDPage page = pdfDoc.getPage(index.intValue());
                int rotation = page.getRotation();
                PDRectangle pdfPageSize = page.getBBox();
                float width = pdfPageSize.getWidth();
                float height = pdfPageSize.getHeight();
                if (rotation == 90 || rotation == 270) {
                    float tmp = width;
                    width = height;
                    height = tmp;
                }
                OFDPageGraphics2D ofdPageG2d = this.ofdDoc.newPage((double)width / this.uuPmm, (double)height / this.uuPmm);
                pdfRender.renderPageToGraphics(index.intValue(), (Graphics2D)ofdPageG2d, (float)(1.0 / this.uuPmm));
                if (!this.enableCopyBookmarks) continue;
                this.exportBookmark(pdfDoc, (PDOutlineNode)pdfOutline, ofdPageG2d.pageID, index);
            }
            if (!this.enableCopyAttachFiles) {
                return;
            }
            String srcFilePath = filepath.toAbsolutePath().toString();
            if (this.copied.contains(srcFilePath)) {
                return;
            }
            this.copied.add(srcFilePath);
            this.copyAttachFiles(pdfDoc, targetPages);
        }
        catch (IOException e) {
            throw new GeneralConvertException("PDF\u8f6c\u6362OFD\u5f02\u5e38", e);
        }
    }

    public void setUUPMM(double uuPmm) {
        this.uuPmm = uuPmm;
    }

    public void setEnableCopyAttachFiles(boolean enableCopyAttachFiles) {
        this.enableCopyAttachFiles = enableCopyAttachFiles;
    }

    public void setEnableCopyBookmarks(boolean enableCopyBookmarks) {
        this.enableCopyBookmarks = enableCopyBookmarks;
    }

    private void exportBookmark(PDDocument pdfDoc, PDOutlineNode bookmark, ST_ID pageID, int targetIndex) throws IOException {
        if (bookmark == null) {
            return;
        }
        for (PDOutlineItem current = bookmark.getFirstChild(); current != null; current = current.getNextSibling()) {
            PDPageDestination pd = null;
            PDDestination destination = current.getDestination();
            if (destination instanceof PDPageDestination) {
                pd = (PDPageDestination)destination;
            } else if (destination instanceof PDNamedDestination) {
                pd = pdfDoc.getDocumentCatalog().findNamedDestinationPage((PDNamedDestination)destination);
            }
            if (current.getAction() instanceof PDActionGoTo) {
                PDActionGoTo gta = (PDActionGoTo)current.getAction();
                if (gta.getDestination() instanceof PDPageDestination) {
                    pd = (PDPageDestination)gta.getDestination();
                } else if (gta.getDestination() instanceof PDNamedDestination) {
                    pd = pdfDoc.getDocumentCatalog().findNamedDestinationPage((PDNamedDestination)gta.getDestination());
                }
            }
            if (pd != null && pd.retrievePageNumber() == targetIndex) {
                PDPageXYZDestination dst;
                CT_Dest ctDest = null;
                if (destination instanceof PDPageXYZDestination) {
                    float zoom;
                    dst = (PDPageXYZDestination)destination;
                    ctDest = new CT_Dest().setPageID(pageID.ref());
                    ctDest.setType(DestType.XYZ);
                    float left = dst.getLeft();
                    if (left > 0.0f) {
                        ctDest.setLeft((double)left / this.uuPmm);
                    }
                    if (dst.getTop() > 0) {
                        float top = dst.getPage().getBBox().getHeight() - (float)dst.getTop();
                        ctDest.setTop((double)top / this.uuPmm);
                    }
                    if ((zoom = dst.getZoom()) > 0.0f) {
                        ctDest.setZoom((double)zoom);
                    }
                } else if (destination instanceof PDPageFitHeightDestination) {
                    dst = (PDPageFitHeightDestination)destination;
                    ctDest = new CT_Dest().setPageID(pageID.ref());
                    ctDest.setType(DestType.FitV);
                    int left = dst.getLeft();
                    if (left > 0) {
                        ctDest.setLeft((double)left / this.uuPmm);
                    }
                } else if (destination instanceof PDPageFitWidthDestination) {
                    dst = (PDPageFitWidthDestination)destination;
                    ctDest = new CT_Dest().setPageID(pageID.ref());
                    ctDest.setType(DestType.FitH);
                    if (dst.getTop() > 0) {
                        float top = dst.getPage().getBBox().getHeight() - (float)dst.getTop();
                        ctDest.setTop((double)top / this.uuPmm);
                    }
                } else if (destination instanceof PDPageFitRectangleDestination) {
                    int right;
                    dst = (PDPageFitRectangleDestination)destination;
                    ctDest = new CT_Dest().setPageID(pageID.ref());
                    ctDest.setType(DestType.FitR);
                    float height = dst.getPage().getBBox().getHeight();
                    int left = dst.getLeft();
                    if (left > 0) {
                        ctDest.setLeft((double)left / this.uuPmm);
                    }
                    if (dst.getTop() > 0) {
                        float top = height - (float)dst.getTop();
                        ctDest.setTop((double)top / this.uuPmm);
                    }
                    if ((right = dst.getRight()) > 0) {
                        ctDest.setRight((double)right);
                    }
                    if (dst.getBottom() > 0) {
                        float bottom = height - (float)dst.getBottom();
                        ctDest.setTop((double)bottom / this.uuPmm);
                    }
                }
                if (ctDest != null) {
                    if (this.bookmarks == null) {
                        this.bookmarks = new Bookmarks();
                        this.ofdDoc.document.setBookmarks(this.bookmarks);
                    }
                    this.bookmarks.addBookmark(new Bookmark(current.getTitle(), ctDest));
                }
            }
            this.exportBookmark(pdfDoc, (PDOutlineNode)current, pageID, targetIndex);
        }
    }

    private void copyAttachFiles(PDDocument document, List<Integer> targetPages) throws IOException {
        PDDocumentNameDictionary namesDictionary = new PDDocumentNameDictionary(document.getDocumentCatalog());
        PDEmbeddedFilesNameTreeNode efTree = namesDictionary.getEmbeddedFiles();
        if (efTree != null) {
            this.extractFilesFromEFTree((PDNameTreeNode<PDComplexFileSpecification>)efTree);
        }
        for (Integer index : targetPages) {
            this.extractFilesFromPage(document.getPage(index.intValue()));
        }
    }

    private void extractFilesFromPage(PDPage page) throws IOException {
        for (PDAnnotation annotation : page.getAnnotations()) {
            PDAnnotationFileAttachment annotationFileAttachment;
            PDFileSpecification fileSpec;
            if (!(annotation instanceof PDAnnotationFileAttachment) || !((fileSpec = (annotationFileAttachment = (PDAnnotationFileAttachment)annotation).getFile()) instanceof PDComplexFileSpecification)) continue;
            this.addFileToOFD((PDComplexFileSpecification)fileSpec);
        }
    }

    private void extractFilesFromEFTree(PDNameTreeNode<PDComplexFileSpecification> efTree) throws IOException {
        Map names = efTree.getNames();
        if (names != null) {
            for (Map.Entry entry : names.entrySet()) {
                PDComplexFileSpecification fileSpec = (PDComplexFileSpecification)entry.getValue();
                this.addFileToOFD(fileSpec);
            }
        } else {
            List kids = efTree.getKids();
            if (kids == null) {
                return;
            }
            for (PDNameTreeNode node : kids) {
                this.extractFilesFromEFTree((PDNameTreeNode<PDComplexFileSpecification>)node);
            }
        }
    }

    private void addFileToOFD(PDComplexFileSpecification fileSpec) throws IOException {
        PDEmbeddedFile embeddedFile = this.getEmbeddedFile(fileSpec);
        if (embeddedFile == null) {
            return;
        }
        String filename = fileSpec.getFilename();
        String desp = fileSpec.getFileDescription();
        Calendar creationDate = embeddedFile.getCreationDate();
        Calendar modDate = embeddedFile.getModDate();
        String subtype = embeddedFile.getSubtype();
        CT_Attachment attObj = new CT_Attachment();
        if (desp != null && desp.length() > 0) {
            attObj.setUsage(desp);
        }
        String name = filename;
        int off = filename.lastIndexOf(46);
        if (off > 0) {
            name = filename.substring(0, off);
        }
        attObj.setAttachmentName(name);
        if (creationDate == null) {
            attObj.setCreationDate(LocalDateTime.now());
        } else {
            attObj.setCreationDate(LocalDateTime.ofInstant(creationDate.toInstant(), creationDate.getTimeZone().toZoneId()));
        }
        if (modDate != null) {
            attObj.setCreationDate(LocalDateTime.ofInstant(modDate.toInstant(), modDate.getTimeZone().toZoneId()));
        }
        attObj.setFormat(subtype);
        try (COSInputStream inputStream = embeddedFile.createInputStream();){
            this.ofdDoc.addAttachment(attObj, (InputStream)inputStream);
        }
    }

    private PDEmbeddedFile getEmbeddedFile(PDComplexFileSpecification fileSpec) {
        PDEmbeddedFile embeddedFile = null;
        if (fileSpec != null) {
            embeddedFile = fileSpec.getEmbeddedFileUnicode();
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFileDos();
            }
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFileMac();
            }
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFileUnix();
            }
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFile();
            }
        }
        return embeddedFile;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.ofdDoc != null) {
            this.ofdDoc.close();
        }
    }
}

