/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.converter.export;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.List;
import org.ofdrw.converter.GeneralConvertException;
import org.ofdrw.converter.export.OFDExporter;
import org.ofdrw.reader.ContentExtractor;
import org.ofdrw.reader.OFDReader;

public class TextExporter
implements OFDExporter {
    final OFDReader ofdReader;
    final ContentExtractor extractor;
    final PrintStream out;
    private boolean closed = false;

    public TextExporter(Path ofdFilePath, Path txtPath) throws IOException {
        this.ofdReader = new OFDReader(ofdFilePath);
        if (txtPath == null) {
            throw new IllegalArgumentException("\u5bfc\u51fa\u6587\u672c\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
        }
        if (!Files.exists(txtPath = txtPath.toAbsolutePath(), new LinkOption[0])) {
            Path parent = txtPath.getParent();
            if (Files.exists(parent, new LinkOption[0])) {
                if (!Files.isDirectory(parent, new LinkOption[0])) {
                    throw new IllegalArgumentException("\u5df2\u7ecf\u5b58\u5728\u540c\u540d\u6587\u4ef6: " + parent);
                }
            } else {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            Files.createFile(txtPath, new FileAttribute[0]);
        }
        this.extractor = new ContentExtractor(this.ofdReader);
        this.out = new PrintStream(Files.newOutputStream(txtPath, new OpenOption[0]));
    }

    public TextExporter(InputStream ofdInput, OutputStream txtOutput) throws IOException {
        this.ofdReader = new OFDReader(ofdInput);
        if (txtOutput == null) {
            throw new IllegalArgumentException("\u5bfc\u51fa\u6d41\u4e3a\u7a7a");
        }
        this.extractor = new ContentExtractor(this.ofdReader);
        this.out = new PrintStream(txtOutput);
    }

    @Override
    public void export(int ... indexes) throws GeneralConvertException {
        LinkedList<Integer> targetPages = new LinkedList<Integer>();
        if (indexes == null || indexes.length == 0) {
            for (int i = 0; i < this.ofdReader.getNumberOfPages(); ++i) {
                targetPages.add(i);
            }
        } else {
            int maxPageIndex = this.ofdReader.getNumberOfPages();
            for (int index : indexes) {
                if (index < 0 || index >= maxPageIndex) continue;
                targetPages.add(index);
            }
        }
        for (Integer index : targetPages) {
            List pageContent = this.extractor.getPageContent(index + 1);
            pageContent.forEach(this.out::println);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.out != null) {
            this.out.close();
        }
        if (this.ofdReader != null) {
            this.ofdReader.close();
        }
    }
}

