/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.converter;

import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.io.image.ImageData;
import com.itextpdf.io.image.ImageDataFactory;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.ColorConstants;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.colorspace.PdfColorSpace;
import com.itextpdf.kernel.pdf.colorspace.PdfDeviceCs;
import com.itextpdf.kernel.pdf.colorspace.PdfPattern;
import com.itextpdf.kernel.pdf.colorspace.PdfShading;
import com.itextpdf.kernel.pdf.extgstate.PdfExtGState;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.kernel.pdf.xobject.PdfImageXObject;
import com.itextpdf.kernel.pdf.xobject.PdfXObject;
import com.itextpdf.layout.Canvas;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.apache.pdfbox.util.Matrix;
import org.dom4j.Element;
import org.ofdrw.converter.ColorConvert;
import org.ofdrw.converter.FontLoader;
import org.ofdrw.converter.font.FontWrapper;
import org.ofdrw.converter.point.PathPoint;
import org.ofdrw.converter.point.TextCodePoint;
import org.ofdrw.converter.utils.CommonUtil;
import org.ofdrw.converter.utils.PointUtil;
import org.ofdrw.converter.utils.StringUtils;
import org.ofdrw.core.annotation.pageannot.Annot;
import org.ofdrw.core.basicStructure.pageObj.layer.CT_Layer;
import org.ofdrw.core.basicStructure.pageObj.layer.PageBlockType;
import org.ofdrw.core.basicStructure.pageObj.layer.block.CT_PageBlock;
import org.ofdrw.core.basicStructure.pageObj.layer.block.CompositeObject;
import org.ofdrw.core.basicStructure.pageObj.layer.block.ImageObject;
import org.ofdrw.core.basicStructure.pageObj.layer.block.PathObject;
import org.ofdrw.core.basicStructure.pageObj.layer.block.TextObject;
import org.ofdrw.core.basicType.ST_Array;
import org.ofdrw.core.basicType.ST_Box;
import org.ofdrw.core.basicType.ST_Pos;
import org.ofdrw.core.basicType.ST_RefID;
import org.ofdrw.core.compositeObj.CT_VectorG;
import org.ofdrw.core.graph.pathObj.FillColor;
import org.ofdrw.core.graph.pathObj.StrokeColor;
import org.ofdrw.core.pageDescription.CT_GraphicUnit;
import org.ofdrw.core.pageDescription.color.color.CT_AxialShd;
import org.ofdrw.core.pageDescription.color.color.CT_Color;
import org.ofdrw.core.pageDescription.color.color.Segment;
import org.ofdrw.core.pageDescription.drawParam.CT_DrawParam;
import org.ofdrw.core.signatures.appearance.StampAnnot;
import org.ofdrw.core.text.font.CT_Font;
import org.ofdrw.reader.OFDReader;
import org.ofdrw.reader.PageInfo;
import org.ofdrw.reader.ResourceLocator;
import org.ofdrw.reader.ResourceManage;
import org.ofdrw.reader.model.AnnotionEntity;
import org.ofdrw.reader.model.StampAnnotEntity;
import org.ofdrw.reader.tools.ImageUtils;

public class ItextMaker {
    private Map<String, FontWrapper<PdfFont>> fontCache = new HashMap<String, FontWrapper<PdfFont>>();
    private final OFDReader ofdReader;
    private final ResourceManage resMgt;
    private PdfFont DEFAULT_FONT;

    public ItextMaker(OFDReader ofdReader) throws IOException {
        this.ofdReader = ofdReader;
        this.resMgt = ofdReader.getResMgt();
        byte[] font = IOUtils.toByteArray((InputStream)this.getClass().getClassLoader().getResourceAsStream("fonts/simsun.ttf"));
        this.DEFAULT_FONT = PdfFontFactory.createFont((byte[])font, (String)"Cp1252", (boolean)true);
    }

    public PdfPage makePage(PdfDocument pdf, PageInfo pageInfo) throws IOException {
        ST_Box pageBox = pageInfo.getSize();
        double pageWidthPixel = CommonUtil.converterDpi(pageBox.getWidth());
        double pageHeightPixel = CommonUtil.converterDpi(pageBox.getHeight());
        PageSize pageSize = new PageSize((float)pageWidthPixel, (float)pageHeightPixel);
        PdfPage pdfPage = pdf.addNewPage(pageSize);
        pdfPage.setMediaBox(new Rectangle((float)CommonUtil.converterDpi(pageBox.getTopLeftX()), (float)CommonUtil.converterDpi(pageBox.getTopLeftY()), (float)CommonUtil.converterDpi(pageBox.getWidth()), (float)CommonUtil.converterDpi(pageBox.getHeight())));
        List annotationEntities = this.ofdReader.getAnnotationEntities();
        List stampAnnots = this.ofdReader.getStampAnnots();
        PdfCanvas pdfCanvas = new PdfCanvas(pdfPage);
        List layerList = pageInfo.getAllLayer();
        this.writeLayer(this.resMgt, pdfCanvas, layerList, pageBox, null);
        this.writeStamp(pdf, pdfCanvas, pageInfo, stampAnnots);
        this.writeAnnoAppearance(this.resMgt, pdfCanvas, pageInfo, annotationEntities, pageBox);
        return pdfPage;
    }

    private void writeStamp(PdfDocument pdf, PdfCanvas pdfCanvas, PageInfo parent, List<StampAnnotEntity> stampAnnotEntityList) throws IOException {
        String pageID = parent.getId().toString();
        for (StampAnnotEntity stampAnnotVo : stampAnnotEntityList) {
            List stampAnnots = stampAnnotVo.getStampAnnots();
            for (StampAnnot stampAnnot : stampAnnots) {
                if (!stampAnnot.getPageRef().toString().equals(pageID)) continue;
                ST_Box pageBox = parent.getSize();
                ST_Box sealBox = stampAnnot.getBoundary();
                ST_Box clipBox = stampAnnot.getClip();
                if (stampAnnotVo.getImgType().equalsIgnoreCase("ofd")) {
                    OFDReader sealOfdReader = new OFDReader((InputStream)new ByteArrayInputStream(stampAnnotVo.getImageByte()));
                    Throwable throwable = null;
                    try {
                        ResourceManage sealResMgt = sealOfdReader.getResMgt();
                        for (PageInfo ofdPageVo : sealOfdReader.getPageList()) {
                            List layerList = ofdPageVo.getAllLayer();
                            this.writeLayer(sealResMgt, pdfCanvas, layerList, pageBox, sealBox);
                            this.writeAnnoAppearance(sealResMgt, pdfCanvas, ofdPageVo, sealOfdReader.getAnnotationEntities(), pageBox);
                        }
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (sealOfdReader == null) continue;
                        if (throwable != null) {
                            try {
                                sealOfdReader.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        sealOfdReader.close();
                        continue;
                    }
                }
                this.writeSealImage(pdf, pdfCanvas, pageBox, stampAnnotVo.getImageByte(), sealBox, clipBox);
            }
        }
    }

    private void writeLayer(ResourceManage resMgt, PdfCanvas pdfCanvas, List<CT_Layer> layerList, ST_Box box, ST_Box sealBox) throws IOException {
        for (CT_Layer layer : layerList) {
            this.writePageBlock(resMgt, pdfCanvas, box, sealBox, layer.getPageBlocks(), layer.getDrawParam(), null, null, null, null);
        }
    }

    private void writeAnnoAppearance(ResourceManage resMgt, PdfCanvas pdfCanvas, PageInfo pageInfo, List<AnnotionEntity> annotionEntities, ST_Box box) throws IOException {
        String pageId = pageInfo.getId().toString();
        for (AnnotionEntity annotionEntity : annotionEntities) {
            List annotList = annotionEntity.getAnnots();
            if (annotList == null || !pageId.equalsIgnoreCase(annotionEntity.getPageId())) continue;
            for (Annot annot : annotList) {
                List pageBlockTypeList = annot.getAppearance().getPageBlocks();
                ST_Box annotBox = annot.getAppearance().getBoundary();
                this.writePageBlock(resMgt, pdfCanvas, box, null, pageBlockTypeList, null, annotBox, null, null, null);
            }
        }
    }

    private void writePageBlock(ResourceManage resMgt, PdfCanvas pdfCanvas, ST_Box box, ST_Box sealBox, List<PageBlockType> pageBlockTypeList, ST_RefID drawparam, ST_Box annotBox, Integer compositeObjectAlpha, ST_Box compositeObjectBoundary, ST_Array compositeObjectCTM) throws IOException {
        Color defaultStrokeColor = ColorConstants.BLACK;
        Color defaultFillColor = ColorConstants.BLACK;
        float defaultLineWidth = 0.353f;
        CT_DrawParam ctDrawParam = null;
        if (drawparam != null) {
            ctDrawParam = resMgt.getDrawParamFinal(drawparam.toString());
        }
        if (ctDrawParam != null) {
            if (ctDrawParam.getLineWidth() != null) {
                defaultLineWidth = ctDrawParam.getLineWidth().floatValue();
            }
            if (ctDrawParam.getStrokeColor() != null) {
                defaultStrokeColor = ColorConvert.pdfRGB(resMgt, ctDrawParam.getStrokeColor());
            }
            if (ctDrawParam.getFillColor() != null) {
                defaultFillColor = ColorConvert.pdfRGB(resMgt, (CT_Color)ctDrawParam.getFillColor());
            }
        }
        for (PageBlockType block : pageBlockTypeList) {
            if (block instanceof TextObject) {
                Color fillColor = defaultFillColor;
                TextObject textObject = (TextObject)block;
                int alpha = 255;
                FillColor ctFillColor = textObject.getFillColor();
                if (ctFillColor != null) {
                    if (ctFillColor.getValue() != null) {
                        fillColor = ColorConvert.pdfRGB(resMgt, (CT_Color)ctFillColor);
                    } else if (ctFillColor.getColorByType() != null) {
                        CT_AxialShd ctAxialShd = (CT_AxialShd)ctFillColor.getColorByType();
                        fillColor = ColorConvert.pdfRGB(resMgt, ((Segment)ctAxialShd.getSegments().get(0)).getColor());
                    }
                    alpha = ctFillColor.getAlpha();
                }
                this.writeText(resMgt, pdfCanvas, box, sealBox, annotBox, textObject, fillColor, alpha, compositeObjectAlpha, compositeObjectBoundary, compositeObjectCTM);
                continue;
            }
            if (block instanceof ImageObject) {
                ImageObject imageObject = (ImageObject)block;
                resMgt.superDrawParam((CT_GraphicUnit)imageObject);
                this.writeImage(resMgt, pdfCanvas, box, imageObject, annotBox, compositeObjectAlpha, compositeObjectBoundary, compositeObjectCTM);
                continue;
            }
            if (block instanceof PathObject) {
                PathObject pathObject = (PathObject)block;
                resMgt.superDrawParam((CT_GraphicUnit)pathObject);
                this.writePath(resMgt, pdfCanvas, box, sealBox, annotBox, pathObject, defaultFillColor, defaultStrokeColor, defaultLineWidth, compositeObjectAlpha, compositeObjectBoundary, compositeObjectCTM);
                continue;
            }
            if (block instanceof CompositeObject) {
                CompositeObject compositeObject = (CompositeObject)block;
                CT_VectorG vectorG = resMgt.getCompositeGraphicUnit(compositeObject.getResourceID().toString());
                Integer currentCompositeObjectAlpha = compositeObject.getAlpha();
                ST_Box currentCompositeObjectBoundary = compositeObject.getBoundary();
                ST_Array currentCompositeObjectCTM = compositeObject.getCTM();
                this.writePageBlock(resMgt, pdfCanvas, box, sealBox, vectorG.getContent().getPageBlocks(), drawparam, annotBox, currentCompositeObjectAlpha, currentCompositeObjectBoundary, currentCompositeObjectCTM);
                continue;
            }
            if (!(block instanceof CT_PageBlock)) continue;
            this.writePageBlock(resMgt, pdfCanvas, box, sealBox, ((CT_PageBlock)block).getPageBlocks(), drawparam, annotBox, compositeObjectAlpha, compositeObjectBoundary, compositeObjectCTM);
        }
    }

    private void writePath(ResourceManage resMgt, PdfCanvas pdfCanvas, ST_Box box, ST_Box sealBox, ST_Box annotBox, PathObject pathObject, Color defaultFillColor, Color defaultStrokeColor, float defaultLineWidth, Integer compositeObjectAlpha, ST_Box compositeObjectBoundary, ST_Array compositeObjectCTM) {
        float lineWidth;
        pdfCanvas.saveState();
        CT_DrawParam ctDrawParam = resMgt.superDrawParam((CT_GraphicUnit)pathObject);
        if (ctDrawParam != null) {
            if (pathObject.getStrokeColor() == null && ctDrawParam.getStrokeColor() != null) {
                pathObject.setStrokeColor(new CT_Color().setValue(ctDrawParam.getStrokeColor().getValue()));
            }
            if (pathObject.getFillColor() == null && ctDrawParam.getFillColor() != null) {
                pathObject.setStrokeColor(new CT_Color().setValue(ctDrawParam.getFillColor().getValue()));
            }
            if (pathObject.getLineWidth() == null && ctDrawParam.getLineWidth() != null) {
                pathObject.setLineWidth(ctDrawParam.getLineWidth());
            }
        }
        if (pathObject.getStrokeColor() != null) {
            Element e;
            StrokeColor strokeColor = pathObject.getStrokeColor();
            if (strokeColor.getValue() != null) {
                pdfCanvas.setStrokeColor(ColorConvert.pdfRGB(resMgt, (CT_Color)strokeColor));
            }
            if ((e = strokeColor.getOFDElement("AxialShd")) != null) {
                CT_AxialShd ctAxialShd = new CT_AxialShd(e);
                CT_Color startColor = ((Segment)ctAxialShd.getSegments().get(0)).getColor();
                CT_Color endColor = ((Segment)ctAxialShd.getSegments().get(ctAxialShd.getSegments().size() - 1)).getColor();
                ST_Array start = startColor.getValue();
                ST_Array end = endColor.getValue();
                ST_Pos startPos = ctAxialShd.getStartPoint();
                ST_Pos endPos = ctAxialShd.getEndPoint();
                double x1 = startPos.getX();
                double y1 = startPos.getY();
                double x2 = endPos.getX();
                double y2 = endPos.getY();
                if (pathObject.getCTM() != null) {
                    double[] newPoint = PointUtil.ctmCalPoint(startPos.getX(), startPos.getY(), pathObject.getCTM().toDouble());
                    x1 = newPoint[0];
                    y1 = newPoint[1];
                    newPoint = PointUtil.ctmCalPoint(x2, y2, pathObject.getCTM().toDouble());
                    x2 = newPoint[0];
                    y2 = newPoint[1];
                }
                double[] realPos = PointUtil.adjustPos(box.getWidth(), box.getHeight(), x1, y1, pathObject.getBoundary());
                x1 = realPos[0];
                y1 = box.getHeight() - realPos[1];
                realPos = PointUtil.adjustPos(box.getWidth(), box.getHeight(), x2, y2, pathObject.getBoundary());
                x2 = realPos[0];
                y2 = box.getHeight() - realPos[1];
                PdfShading.Axial axial = new PdfShading.Axial((PdfColorSpace)new PdfDeviceCs.Rgb(), 0.0f, 0.0f, ColorConvert.pdfRGB(resMgt, startColor).getColorValue(), box.getWidth().floatValue(), box.getHeight().floatValue(), ColorConvert.pdfRGB(resMgt, endColor).getColorValue());
                PdfPattern.Shading shading = new PdfPattern.Shading((PdfShading)axial);
                pdfCanvas.setStrokeColorShading(shading);
                defaultStrokeColor = ColorConvert.pdfRGB(resMgt, endColor);
                pdfCanvas.setStrokeColor(defaultStrokeColor);
            }
        } else {
            pdfCanvas.setStrokeColor(defaultStrokeColor);
        }
        float f = lineWidth = pathObject.getLineWidth() != null ? pathObject.getLineWidth().floatValue() : defaultLineWidth;
        if (pathObject.getCTM() != null && pathObject.getLineWidth() != null) {
            Double[] ctm = pathObject.getCTM().toDouble();
            double a = ctm[0];
            double b = ctm[1];
            double c = ctm[2];
            double d = ctm[3];
            double e = ctm[4];
            double f2 = ctm[5];
            double sx = Math.signum(a) * Math.sqrt(a * a + c * c);
            double sy = Math.signum(d) * Math.sqrt(b * b + d * d);
            lineWidth = (float)((double)lineWidth * sx);
        }
        if (pathObject.getStroke().booleanValue()) {
            if (pathObject.getDashPattern() != null) {
                float unitsOn = (float)CommonUtil.converterDpi(pathObject.getDashPattern().toDouble()[0].floatValue());
                float unitsOff = (float)CommonUtil.converterDpi(pathObject.getDashPattern().toDouble()[1].floatValue());
                float phase = (float)CommonUtil.converterDpi(pathObject.getDashOffset().floatValue());
                pdfCanvas.setLineDash(unitsOn, unitsOff, phase);
            }
            pdfCanvas.setLineJoinStyle(pathObject.getJoin().ordinal());
            pdfCanvas.setLineCapStyle(pathObject.getCap().ordinal());
            pdfCanvas.setMiterLimit(pathObject.getMiterLimit().floatValue());
            this.path(pdfCanvas, box, sealBox, annotBox, pathObject, compositeObjectBoundary, compositeObjectCTM);
            if (compositeObjectBoundary != null) {
                pdfCanvas.setLineWidth(lineWidth);
            } else {
                pdfCanvas.setLineWidth((float)CommonUtil.converterDpi(lineWidth));
            }
            pdfCanvas.stroke();
            pdfCanvas.restoreState();
        }
        if (pathObject.getFill().booleanValue()) {
            FillColor fillColor;
            pdfCanvas.saveState();
            if (compositeObjectAlpha != null) {
                PdfExtGState gs1 = new PdfExtGState();
                gs1.setFillOpacity((float)compositeObjectAlpha.intValue() * 1.0f / 255.0f);
                pdfCanvas.setExtGState(gs1);
            }
            if ((fillColor = (FillColor)pathObject.getFillColor()) != null) {
                Element e;
                if (fillColor.getValue() != null) {
                    pdfCanvas.setFillColor(ColorConvert.pdfRGB(resMgt, (CT_Color)fillColor));
                }
                if ((e = fillColor.getOFDElement("AxialShd")) != null) {
                    CT_AxialShd ctAxialShd = new CT_AxialShd(e);
                    CT_Color startColor = ((Segment)ctAxialShd.getSegments().get(0)).getColor();
                    CT_Color endColor = ((Segment)ctAxialShd.getSegments().get(ctAxialShd.getSegments().size() - 1)).getColor();
                    ST_Array start = startColor.getValue();
                    ST_Array end = endColor.getValue();
                    ST_Pos startPos = ctAxialShd.getStartPoint();
                    ST_Pos endPos = ctAxialShd.getEndPoint();
                    defaultFillColor = ColorConvert.pdfRGB(resMgt, endColor);
                    pdfCanvas.setFillColor(defaultFillColor);
                }
            } else {
                pdfCanvas.setFillColor(defaultFillColor);
            }
            this.path(pdfCanvas, box, sealBox, annotBox, pathObject, compositeObjectBoundary, compositeObjectCTM);
            pdfCanvas.fill();
            pdfCanvas.restoreState();
        }
    }

    private void path(PdfCanvas pdfCanvas, ST_Box box, ST_Box sealBox, ST_Box annotBox, PathObject pathObject, ST_Box compositeObjectBoundary, ST_Array compositeObjectCTM) {
        if (pathObject.getBoundary() == null) {
            return;
        }
        if (sealBox != null) {
            pathObject.setBoundary(pathObject.getBoundary().getTopLeftX() + sealBox.getTopLeftX(), pathObject.getBoundary().getTopLeftY() + sealBox.getTopLeftY(), pathObject.getBoundary().getWidth().doubleValue(), pathObject.getBoundary().getHeight().doubleValue());
        }
        if (annotBox != null) {
            pathObject.setBoundary(pathObject.getBoundary().getTopLeftX() + CommonUtil.converterDpi(annotBox.getTopLeftX()), pathObject.getBoundary().getTopLeftY() + CommonUtil.converterDpi(annotBox.getTopLeftY()), pathObject.getBoundary().getWidth().doubleValue(), pathObject.getBoundary().getHeight().doubleValue());
        }
        List<PathPoint> listPoint = PointUtil.calPdfPathPoint(box.getWidth(), box.getHeight(), pathObject.getBoundary(), PointUtil.convertPathAbbreviatedDatatoPoint(pathObject.getAbbreviatedData()), pathObject.getCTM() != null, pathObject.getCTM(), compositeObjectBoundary, compositeObjectCTM, true);
        for (int i = 0; i < listPoint.size(); ++i) {
            if (listPoint.get((int)i).type.equals("M") || listPoint.get((int)i).type.equals("S")) {
                pdfCanvas.moveTo((double)listPoint.get((int)i).x1, (double)listPoint.get((int)i).y1);
                continue;
            }
            if (listPoint.get((int)i).type.equals("L")) {
                pdfCanvas.lineTo((double)listPoint.get((int)i).x1, (double)listPoint.get((int)i).y1);
                continue;
            }
            if (listPoint.get((int)i).type.equals("B")) {
                pdfCanvas.curveTo((double)listPoint.get((int)i).x1, (double)listPoint.get((int)i).y1, (double)listPoint.get((int)i).x2, (double)listPoint.get((int)i).y2, (double)listPoint.get((int)i).x3, (double)listPoint.get((int)i).y3);
                continue;
            }
            if (listPoint.get((int)i).type.equals("Q")) {
                pdfCanvas.curveTo((double)listPoint.get((int)i).x1, (double)listPoint.get((int)i).y1, (double)listPoint.get((int)i).x2, (double)listPoint.get((int)i).y2);
                continue;
            }
            if (!listPoint.get((int)i).type.equals("C")) continue;
            pdfCanvas.closePath();
        }
    }

    private void writeImage(ResourceManage resMgt, PdfCanvas pdfCanvas, ST_Box box, ImageObject imageObject, ST_Box annotBox, Integer compositeObjectAlpha, ST_Box compositeObjectBoundary, ST_Array compositeObjectCTM) throws IOException {
        byte[] imageByteArray = resMgt.getImageByteArray(imageObject.getResourceID().toString());
        if (imageByteArray == null) {
            return;
        }
        pdfCanvas.saveState();
        PdfImageXObject pdfImageObject = new PdfImageXObject(ImageDataFactory.create((byte[])imageByteArray));
        if (annotBox != null) {
            float x = annotBox.getTopLeftX().floatValue();
            float y = box.getHeight().floatValue() - (annotBox.getTopLeftY().floatValue() + annotBox.getHeight().floatValue());
            float width = annotBox.getWidth().floatValue();
            float height = annotBox.getHeight().floatValue();
            Rectangle rect = new Rectangle((float)CommonUtil.converterDpi(x), (float)CommonUtil.converterDpi(y), (float)CommonUtil.converterDpi(width), (float)CommonUtil.converterDpi(height));
            pdfCanvas.addXObject((PdfXObject)pdfImageObject, rect);
        } else {
            Matrix matrix = CommonUtil.toPFMatrix(CommonUtil.getImageMatrixFromOfd(imageObject, box, compositeObjectCTM));
            float a = matrix.getValue(0, 0);
            float b = matrix.getValue(0, 1);
            float c = matrix.getValue(1, 0);
            float d = matrix.getValue(1, 1);
            float e = matrix.getValue(2, 0);
            float f = matrix.getValue(2, 1);
            pdfCanvas.addXObject((PdfXObject)pdfImageObject, a, b, c, d, e, f);
        }
        pdfCanvas.restoreState();
    }

    private void writeSealImage(PdfDocument pdfDocument, PdfCanvas pdfCanvas, ST_Box box, byte[] image, ST_Box sealBox, ST_Box clipBox) throws IOException {
        if (image == null) {
            return;
        }
        float x = sealBox.getTopLeftX().floatValue();
        float y = box.getHeight().floatValue() - (sealBox.getTopLeftY().floatValue() + sealBox.getHeight().floatValue());
        float width = sealBox.getWidth().floatValue();
        float height = sealBox.getHeight().floatValue();
        Rectangle rect = new Rectangle((float)CommonUtil.converterDpi(x), (float)CommonUtil.converterDpi(y), (float)CommonUtil.converterDpi(width), (float)CommonUtil.converterDpi(height));
        BufferedImage bImg = ImageUtils.clearWhiteBackground((BufferedImage)ImageIO.read(new ByteArrayInputStream(image)), (int)244);
        ImageData img = ImageDataFactory.create((Image)bImg, null);
        PdfFormXObject xObject = new PdfFormXObject(new Rectangle(rect.getWidth(), rect.getHeight()));
        PdfCanvas xObjectCanvas = new PdfCanvas(xObject, pdfDocument);
        if (clipBox != null) {
            xObjectCanvas.rectangle(CommonUtil.converterDpi(clipBox.getTopLeftX()), (double)rect.getHeight() - (CommonUtil.converterDpi(clipBox.getTopLeftY()) + CommonUtil.converterDpi(clipBox.getHeight())), CommonUtil.converterDpi(clipBox.getWidth()), CommonUtil.converterDpi(clipBox.getHeight()));
            xObjectCanvas.clip();
            xObjectCanvas.endPath();
        }
        xObjectCanvas.addImage(img, rect.getWidth(), 0.0f, 0.0f, rect.getHeight(), 0.0f, 0.0f);
        com.itextpdf.layout.element.Image clipped = new com.itextpdf.layout.element.Image(xObject);
        Canvas canvas = new Canvas(pdfCanvas, pdfDocument, rect);
        canvas.add(clipped);
        canvas.close();
    }

    private void writeText(ResourceManage resMgt, PdfCanvas pdfCanvas, ST_Box box, ST_Box sealBox, ST_Box annotBox, TextObject textObject, Color fillColor, int alpha, Integer compositeObjectAlpha, ST_Box compositeObjectBoundary, ST_Array compositeObjectCTM) throws IOException {
        double sx;
        double f;
        double e;
        double d;
        Double[] ctm;
        Element e2;
        float fontSize = textObject.getSize().floatValue();
        pdfCanvas.setFillColor(fillColor);
        if (textObject.getFillColor() != null && (e2 = textObject.getFillColor().getOFDElement("AxialShd")) != null) {
            CT_AxialShd ctAxialShd = new CT_AxialShd(e2);
            CT_Color startColor = ((Segment)ctAxialShd.getSegments().get(0)).getColor();
            CT_Color endColor = ((Segment)ctAxialShd.getSegments().get(ctAxialShd.getSegments().size() - 1)).getColor();
            ST_Array start = startColor.getValue();
            ST_Array end = endColor.getValue();
            ST_Pos startPos = ctAxialShd.getStartPoint();
            ST_Pos endPos = ctAxialShd.getEndPoint();
            double x1 = startPos.getX();
            double y1 = startPos.getY();
            double x2 = endPos.getX();
            double y2 = endPos.getY();
            if (textObject.getCTM() != null) {
                double[] newPoint = PointUtil.ctmCalPoint(startPos.getX(), startPos.getY(), textObject.getCTM().toDouble());
                x1 = newPoint[0];
                y1 = newPoint[1];
                newPoint = PointUtil.ctmCalPoint(x2, y2, textObject.getCTM().toDouble());
                x2 = newPoint[0];
                y2 = newPoint[1];
            }
            double[] realPos = PointUtil.adjustPos(box.getWidth(), box.getHeight(), x1, y1, textObject.getBoundary());
            x1 = realPos[0];
            y1 = box.getHeight() - realPos[1];
            realPos = PointUtil.adjustPos(box.getWidth(), box.getHeight(), x2, y2, textObject.getBoundary());
            x2 = realPos[0];
            y2 = box.getHeight() - realPos[1];
            PdfShading.Axial axial = new PdfShading.Axial((PdfColorSpace)new PdfDeviceCs.Rgb(), (float)x1, (float)y1, ColorConvert.pdfRGB(resMgt, startColor).getColorValue(), (float)x2, (float)y2, ColorConvert.pdfRGB(resMgt, endColor).getColorValue());
            PdfPattern.Shading shading = new PdfPattern.Shading((PdfShading)axial);
            pdfCanvas.setFillColorShading(shading);
        }
        PdfExtGState gs1 = new PdfExtGState();
        gs1.setFillOpacity((float)alpha / 255.0f);
        pdfCanvas.setExtGState(gs1);
        if (sealBox != null && textObject.getBoundary() != null) {
            textObject.setBoundary(textObject.getBoundary().getTopLeftX() + sealBox.getTopLeftX(), textObject.getBoundary().getTopLeftY() + sealBox.getTopLeftY(), textObject.getBoundary().getWidth().doubleValue(), textObject.getBoundary().getHeight().doubleValue());
        }
        if (annotBox != null && textObject.getBoundary() != null) {
            textObject.setBoundary(textObject.getBoundary().getTopLeftX() + annotBox.getTopLeftX(), textObject.getBoundary().getTopLeftY() + annotBox.getTopLeftY(), textObject.getBoundary().getWidth().doubleValue(), textObject.getBoundary().getHeight().doubleValue());
        }
        if (textObject.getCTM() != null) {
            ctm = textObject.getCTM().toDouble();
            double a = ctm[0];
            double b = ctm[1];
            double c = ctm[2];
            d = ctm[3];
            e = ctm[4];
            f = ctm[5];
            sx = a > 0.0 ? Math.signum(a) * Math.sqrt(a * a + c * c) : Math.sqrt(a * a + c * c);
            double angel = Math.atan2(-b, d);
            if (angel != 0.0 || a == 0.0 || d != 1.0) {
                fontSize = (float)((double)fontSize * sx);
            }
        }
        if (compositeObjectCTM != null) {
            ctm = compositeObjectCTM.toDouble();
            double a = ctm[0];
            double b = ctm[1];
            double c = ctm[2];
            d = ctm[3];
            e = ctm[4];
            f = ctm[5];
            sx = a > 0.0 ? Math.signum(a) * Math.sqrt(a * a + c * c) : Math.sqrt(a * a + c * c);
            double angel = Math.atan2(-b, d);
            if (angel != 0.0 || a == 0.0 || d != 1.0) {
                fontSize = (float)((double)fontSize * sx);
            }
        }
        CT_Font ctFont = resMgt.getFont(textObject.getFont().toString());
        FontWrapper<PdfFont> pdfFontWrapper = this.getFont(resMgt.getOfdReader().getResourceLocator(), ctFont);
        PdfFont font = pdfFontWrapper.getFont();
        List<TextCodePoint> textCodePointList = PointUtil.calPdfTextCoordinate(box.getWidth(), box.getHeight(), textObject.getBoundary(), fontSize, textObject.getTextCodes(), textObject.getCGTransforms(), compositeObjectBoundary, compositeObjectCTM, textObject.getCTM() != null, textObject.getCTM(), true);
        double rx = 0.0;
        double ry = 0.0;
        for (int i = 0; i < textCodePointList.size(); ++i) {
            TextCodePoint textCodePoint = textCodePointList.get(i);
            if (i == 0) {
                rx = textCodePoint.x;
                ry = textCodePoint.y;
            }
            pdfCanvas.saveState();
            pdfCanvas.beginText();
            if (textObject.getMiterLimit() > 0.0) {
                pdfCanvas.setMiterLimit(textObject.getMiterLimit().floatValue());
            }
            pdfCanvas.moveText(textCodePoint.getX(), textCodePoint.getY());
            if (textObject.getCTM() != null) {
                Double[] ctm2 = textObject.getCTM().toDouble();
                double a = ctm2[0];
                double b = ctm2[1];
                double c = ctm2[2];
                double d2 = ctm2[3];
                double e3 = ctm2[4];
                double f2 = ctm2[5];
                AffineTransform transform = new AffineTransform();
                double angel = Math.atan2(-b, d2);
                transform.rotate(angel, rx, ry);
                pdfCanvas.concatMatrix(transform);
                if (angel == 0.0 && a != 0.0 && d2 == 1.0) {
                    textObject.setHScale(Double.valueOf(a));
                }
            }
            if (textObject.getHScale().floatValue() < 1.0f) {
                AffineTransform transform = new AffineTransform();
                transform.setTransform((double)textObject.getHScale().floatValue(), 0.0, 0.0, 1.0, (double)(1.0f - textObject.getHScale().floatValue()) * textCodePoint.getX(), 0.0);
                pdfCanvas.concatMatrix(transform);
            }
            pdfCanvas.setFontAndSize(font, (float)CommonUtil.converterDpi(fontSize));
            if (textObject.getLineWidth() != null) {
                pdfCanvas.setLineWidth(new Float(textObject.getLineWidth()).floatValue());
                pdfCanvas.setFillColor(ColorConstants.BLACK);
                pdfCanvas.setTextRenderingMode(2);
            }
            if (!StringUtils.isBlank(textCodePoint.getGlyph()) && !pdfFontWrapper.isEnableSimilarFontReplace()) {
                String[] glys;
                ArrayList<Glyph> glyphs = new ArrayList<Glyph>();
                for (String gly : glys = textCodePoint.getGlyph().split(" ")) {
                    Glyph g = font.getFontProgram().getGlyphByCode(Integer.parseInt(gly));
                    if (g == null) continue;
                    glyphs.add(g);
                }
                if (glyphs.size() > 0) {
                    pdfCanvas.showText(new GlyphLine(glyphs));
                } else {
                    pdfCanvas.showText(textCodePoint.getText());
                }
            } else {
                pdfCanvas.showText(textCodePoint.getText());
            }
            pdfCanvas.endText();
            pdfCanvas.restoreState();
        }
    }

    private FontWrapper<PdfFont> getFont(ResourceLocator rl, CT_Font ctFont) {
        String key = String.format("%s_%s_%s", ctFont.getFamilyName(), ctFont.attributeValue("FontName"), ctFont.getFontFile());
        if (this.fontCache.containsKey(key)) {
            return this.fontCache.get(key);
        }
        FontWrapper<PdfFont> font = FontLoader.getInstance().loadPDFFontSimilar(rl, ctFont);
        this.fontCache.put(key, font);
        return font;
    }
}

