/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.http.impl.jdk;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.util.IoUtil;
import org.noear.solon.core.util.MultiMap;
import org.noear.solon.exception.SolonException;
import org.noear.solon.net.http.HttpResponse;
import org.noear.solon.net.http.HttpResponseException;
import org.noear.solon.net.http.impl.jdk.JdkHttpUtils;
import org.noear.solon.net.http.impl.jdk.JdkInputStreamWrapper;

public class JdkHttpResponse
implements HttpResponse {
    private final JdkHttpUtils utils;
    private final HttpURLConnection http;
    private final int statusCode;
    private final String statusMessage;
    private final MultiMap<String> headers;
    private MultiMap<String> cookies;
    private final InputStream body;
    private Charset _contentCharset;
    private Map<String, List<String>> headerMap;

    public JdkHttpResponse(JdkHttpUtils utils, int statusCode, HttpURLConnection http) throws IOException {
        InputStream inputStream;
        this.utils = utils;
        this.http = http;
        this.statusCode = statusCode;
        this.statusMessage = http.getResponseMessage();
        this.headers = new MultiMap();
        for (Map.Entry<String, List<String>> kv : http.getHeaderFields().entrySet()) {
            if (kv.getKey() == null) continue;
            this.headers.holder(kv.getKey()).setValues(kv.getValue());
        }
        InputStream inputStream2 = inputStream = statusCode < 400 ? http.getInputStream() : http.getErrorStream();
        if (null == inputStream) {
            this.body = new ByteArrayInputStream("".getBytes());
        } else {
            String encoding = http.getHeaderField("Content-Encoding");
            if (Utils.isNotEmpty((String)encoding)) {
                if ("gzip".equalsIgnoreCase(encoding)) {
                    if (!(inputStream instanceof GZIPInputStream)) {
                        inputStream = new GZIPInputStream(inputStream);
                    }
                } else if ("deflate".equalsIgnoreCase(encoding) && !(inputStream instanceof InflaterInputStream)) {
                    inputStream = new InflaterInputStream(inputStream, new Inflater(true));
                }
            }
            this.body = new JdkInputStreamWrapper(http, inputStream);
        }
    }

    private MultiMap<String> cookiesInit() {
        if (this.cookies == null) {
            this.cookies = new MultiMap();
            List<String> kvAry = this.headers("Set-Cookie");
            for (String kvStr : kvAry) {
                int eqIdx = kvStr.indexOf("=");
                int smIdx = kvStr.indexOf(";", eqIdx);
                String key = kvStr.substring(0, eqIdx);
                String value = smIdx > 0 ? kvStr.substring(eqIdx + 1, smIdx) : kvStr.substring(eqIdx + 1);
                this.cookies.add(key, (Object)value);
            }
        }
        return this.cookies;
    }

    @Override
    public Collection<String> headerNames() {
        return this.headers.keySet();
    }

    @Override
    public String header(String name) {
        List<String> values = this.headers(name);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.get(0);
    }

    @Override
    public List<String> headers(String name) {
        return this.headers.getAll(name);
    }

    @Override
    public Collection<String> cookieNames() {
        return this.cookiesInit().keySet();
    }

    @Override
    public String cookie(String name) {
        return (String)this.cookiesInit().get(name);
    }

    @Override
    public List<String> cookies(String name) {
        return this.cookiesInit().getAll(name);
    }

    @Override
    public Long contentLength() {
        return this.http.getContentLengthLong();
    }

    @Override
    public String contentType() {
        return this.http.getContentType();
    }

    @Override
    public Charset contentCharset() {
        if (this._contentCharset == null) {
            this._contentCharset = JdkHttpResponse.parseContentCharset(this.contentType());
        }
        return this._contentCharset;
    }

    public static Charset parseContentCharset(String contentType) {
        int charsetIdx;
        if (contentType != null && (charsetIdx = contentType.indexOf("charset=")) > 0) {
            String charset = contentType.substring(charsetIdx + 8);
            if (charset.indexOf(59) > 0) {
                charset = charset.substring(0, charset.indexOf(59));
            }
            return Charset.forName(charset.trim());
        }
        return null;
    }

    @Override
    public List<String> cookies() {
        return this.headers("Set-Cookie");
    }

    @Override
    public int code() {
        return this.statusCode;
    }

    @Override
    public String message() {
        return this.statusMessage;
    }

    @Override
    public InputStream body() {
        return this.body;
    }

    @Override
    public byte[] bodyAsBytes() throws IOException {
        try {
            byte[] byArray = IoUtil.transferToBytes((InputStream)this.body());
            return byArray;
        }
        finally {
            this.body().close();
        }
    }

    @Override
    public String bodyAsString() throws IOException {
        try {
            if (Utils.isEmpty((String)this.http.getContentEncoding())) {
                if (this.utils.charset() == null) {
                    String string = IoUtil.transferToString((InputStream)this.body(), (String)Solon.encoding());
                    return string;
                }
                String string = IoUtil.transferToString((InputStream)this.body(), (String)this.utils.charset().name());
                return string;
            }
            String string = IoUtil.transferToString((InputStream)this.body(), (String)this.http.getContentEncoding());
            return string;
        }
        finally {
            this.body().close();
        }
    }

    @Override
    public <T> T bodyAsBean(Type type) throws IOException {
        if (String.class == this.utils.serializer().dataType()) {
            return (T)this.utils.serializer().deserialize((Object)this.bodyAsString(), type);
        }
        if (byte[].class == this.utils.serializer().dataType()) {
            return (T)this.utils.serializer().deserialize((Object)this.bodyAsBytes(), type);
        }
        throw new SolonException("Invalid serializer type!");
    }

    @Override
    public HttpResponseException createError() {
        return new HttpResponseException(this, this.http.getRequestMethod(), this.http.getURL());
    }

    @Override
    public Map<String, List<String>> headerMap() {
        if (this.headerMap == null) {
            this.headerMap = new LinkedHashMap<String, List<String>>();
            for (String name : this.headerNames()) {
                this.headerMap.put(name, this.headers(name));
            }
        }
        return this.headerMap;
    }

    @Override
    public void close() throws IOException {
        this.body().close();
    }
}

