/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.aot;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import org.noear.eggg.MethodEggg;
import org.noear.eggg.ParamEggg;
import org.noear.eggg.TypeEggg;
import org.noear.solon.aot.RuntimeNativeMetadata;
import org.noear.solon.aot.hint.ExecutableMode;
import org.noear.solon.aot.hint.MemberCategory;
import org.noear.solon.core.util.EgggUtil;
import org.noear.solon.core.util.GenericUtil;
import org.noear.solon.core.wrap.MethodWrap;

public class NativeMetadataUtils {
    public static void registerMethodAndParamAndReturnType(RuntimeNativeMetadata metadata, Method method, Class<?> implementationClass) {
        MethodEggg methodEggg = EgggUtil.getClassEggg(implementationClass).findMethodEgggOrNew(method);
        NativeMetadataUtils.registerMethodAndParamAndReturnType(metadata, methodEggg);
    }

    public static void registerMethodAndParamAndReturnType(RuntimeNativeMetadata metadata, MethodWrap methodWrap) {
        NativeMetadataUtils.registerMethodAndParamAndReturnType(metadata, methodWrap.getMethodEggg());
    }

    public static void registerMethodAndParamAndReturnType(RuntimeNativeMetadata metadata, MethodEggg methodEggg) {
        try {
            metadata.registerMethod(methodEggg.getMethod(), ExecutableMode.INVOKE);
            for (ParamEggg paramEggg : methodEggg.getParamEgggAry()) {
                Class paramType = paramEggg.getType();
                metadata.registerReflection(paramType, MemberCategory.PUBLIC_FIELDS, MemberCategory.DECLARED_FIELDS, MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_METHODS);
                if (!paramType.getName().startsWith("java.") && Serializable.class.isAssignableFrom(paramType)) {
                    metadata.registerSerialization(paramType);
                }
                Type genericType = paramEggg.getGenericType();
                NativeMetadataUtils.processGenericType(metadata, genericType);
            }
            TypeEggg returnTypeEggg = methodEggg.getReturnTypeEggg();
            metadata.registerReflection(returnTypeEggg.getType(), MemberCategory.DECLARED_FIELDS, MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_METHODS);
            if (!returnTypeEggg.getType().getName().startsWith("java.") && Serializable.class.isAssignableFrom(returnTypeEggg.getType())) {
                metadata.registerSerialization(returnTypeEggg.getType());
            }
            Type genericReturnType = returnTypeEggg.getGenericType();
            NativeMetadataUtils.processGenericType(metadata, genericReturnType);
        }
        catch (RuntimeException ex) {
            throw new IllegalStateException("Can't register method: " + methodEggg.getMethod(), ex);
        }
    }

    private static void processGenericType(RuntimeNativeMetadata metadata, Type genericType) {
        if (genericType == null) {
            return;
        }
        Map genericInfo = GenericUtil.getGenericInfo((Type)genericType);
        for (Map.Entry entry : genericInfo.entrySet()) {
            if (((Type)entry.getValue()).getTypeName().startsWith("java.")) continue;
            metadata.registerReflection(((Type)entry.getValue()).getTypeName(), MemberCategory.DECLARED_FIELDS, MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_METHODS);
        }
    }
}

