/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack4.codec.util;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.snack4.SnackException;
import org.noear.snack4.annotation.ONodeAttr;

public class EnumWrap {
    private static Map<String, EnumWrap> enumCached = new ConcurrentHashMap<String, EnumWrap>();
    protected final Map<String, Enum> enumMap = new HashMap<String, Enum>();
    protected final Map<String, Enum> enumCustomMap = new HashMap<String, Enum>();
    protected final Enum[] enumOrdinal;
    protected final Class<?> enumClass;
    protected Field enumCustomFiled;

    public static EnumWrap from(Class<?> clz) {
        String key = clz.getName();
        EnumWrap val = enumCached.get(key);
        if (val == null) {
            val = new EnumWrap(clz);
            enumCached.put(key, val);
        }
        return val;
    }

    public Class<?> enumClass() {
        return this.enumClass;
    }

    public EnumWrap(Class<?> enumClass) {
        this.enumClass = enumClass;
        this.enumOrdinal = (Enum[])enumClass.getEnumConstants();
        if (null == this.enumOrdinal) {
            return;
        }
        for (int i = 0; i < this.enumOrdinal.length; ++i) {
            Enum e = this.enumOrdinal[i];
            if (this.enumMap.containsKey(e.name().toLowerCase())) continue;
            this.enumMap.put(e.name().toLowerCase(), e);
            for (Field f1 : e.getClass().getDeclaredFields()) {
                if (!f1.isAnnotationPresent(ONodeAttr.class)) continue;
                try {
                    if (!f1.isAccessible()) {
                        f1.setAccessible(true);
                    }
                    Object cm = f1.get(e);
                    this.enumCustomFiled = f1;
                    this.enumCustomMap.put(enumClass.getName() + "#" + cm, e);
                }
                catch (IllegalAccessException ex) {
                    throw new SnackException(ex);
                }
            }
        }
    }

    public Enum get(int ordinal) {
        return this.enumOrdinal[ordinal];
    }

    public Enum get(String name) {
        return this.enumMap.get(name.toLowerCase());
    }

    public Enum getCustom(String custom) {
        return this.enumCustomMap.get(this.enumClass.getName() + "#" + custom);
    }

    public boolean hasCustom() {
        return this.enumCustomMap.size() > 0;
    }

    public Object getCustomValue(Object o) {
        try {
            if (this.enumCustomFiled == null) {
                return null;
            }
            return this.enumCustomFiled.get(o);
        }
        catch (IllegalAccessException e) {
            throw new SnackException(e);
        }
    }
}

