/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack4.codec.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.eggg.AnnotatedEggg;
import org.noear.eggg.ClassEggg;
import org.noear.eggg.Eggg;
import org.noear.eggg.FieldEggg;
import org.noear.eggg.ParamEggg;
import org.noear.eggg.Property;
import org.noear.eggg.PropertyMethodEggg;
import org.noear.eggg.TypeEggg;
import org.noear.snack4.annotation.ONodeAttr;
import org.noear.snack4.annotation.ONodeAttrHolder;
import org.noear.snack4.annotation.ONodeCreator;
import org.noear.snack4.codec.util.EgggDigestAddin;

public class EgggUtil {
    private static final Eggg eggg = new Eggg().withCreatorClass(ONodeCreator.class).withDigestHandler(EgggUtil::doDigestHandle).withAliasHandler(EgggUtil::doAliasHandle);
    private static Map<Class<? extends Annotation>, EgggDigestAddin> egggDigestAddins = new ConcurrentHashMap<Class<? extends Annotation>, EgggDigestAddin>();

    public static void addDigestAddin(Class<? extends Annotation> annoType, EgggDigestAddin digestAddin) {
        Objects.requireNonNull(annoType, "annoType");
        Objects.requireNonNull(digestAddin, "digestAddin");
        egggDigestAddins.put(annoType, digestAddin);
    }

    private static String doAliasHandle(ClassEggg cw, AnnotatedEggg s, String ref) {
        if (s.getDigest() instanceof ONodeAttrHolder) {
            return ((ONodeAttrHolder)s.getDigest()).getAlias();
        }
        return ref;
    }

    private static Object doDigestHandle(ClassEggg ce, AnnotatedEggg s, Object ref) {
        ONodeAttr attr = s.getElement().getAnnotation(ONodeAttr.class);
        if (attr == null) {
            if (egggDigestAddins.size() > 0 && s.getAnnotations().length > 0) {
                for (Map.Entry<Class<? extends Annotation>, EgggDigestAddin> entry : egggDigestAddins.entrySet()) {
                    ONodeAttrHolder tmp;
                    Annotation anno = s.getElement().getAnnotation(entry.getKey());
                    if (anno == null || (tmp = entry.getValue().apply(ce, s, anno)) == null) continue;
                    return tmp;
                }
            }
            if (ref != null) {
                return ref;
            }
        }
        if (s instanceof FieldEggg) {
            return new ONodeAttrHolder(attr, ((Field)s.getElement()).getName());
        }
        if (s instanceof PropertyMethodEggg) {
            return new ONodeAttrHolder(attr, Property.resolvePropertyName((String)((Method)s.getElement()).getName()));
        }
        if (s instanceof ParamEggg) {
            return new ONodeAttrHolder(attr, ((Parameter)s.getElement()).getName());
        }
        if (s instanceof ClassEggg && attr != null) {
            return new ONodeAttrHolder(attr, ((Class)s.getElement()).getName());
        }
        return null;
    }

    public static TypeEggg getTypeEggg(Type type) {
        return eggg.getTypeEggg(type);
    }

    public static ClassEggg getClassEggg(Type type) {
        return EgggUtil.getTypeEggg(type).getClassEggg();
    }
}

