/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack4;

import java.util.Date;
import java.util.List;
import java.util.Map;

public enum DataType {
    Undefined,
    Null,
    Boolean,
    Number,
    String,
    Date,
    Array,
    Object;


    public String toString() {
        switch (this) {
            case Undefined: {
                return "undefined";
            }
            case Null: {
                return "null";
            }
            case Boolean: {
                return "boolean";
            }
            case Number: {
                return "number";
            }
            case String: {
                return "string";
            }
            case Date: {
                return "date";
            }
            case Array: {
                return "array";
            }
            case Object: {
                return "object";
            }
        }
        return "unknown";
    }

    public static boolean isValue(DataType type) {
        return type.ordinal() > Null.ordinal() && type.ordinal() < Array.ordinal();
    }

    public static DataType resolveType(Object value) {
        if (value == null) {
            return Null;
        }
        if (value instanceof Boolean) {
            return Boolean;
        }
        if (value instanceof Number) {
            return Number;
        }
        if (value instanceof String) {
            return String;
        }
        if (value instanceof Date) {
            return Date;
        }
        if (value instanceof List) {
            return Array;
        }
        if (value instanceof Map) {
            return Object;
        }
        throw new IllegalArgumentException("Unsupported type");
    }

    public static DataType resolveValueType(Object value) {
        if (value == null) {
            return Null;
        }
        if (value instanceof Boolean) {
            return Boolean;
        }
        if (value instanceof Number) {
            return Number;
        }
        if (value instanceof String) {
            return String;
        }
        if (value instanceof Date) {
            return Date;
        }
        throw new IllegalArgumentException("Unsupported value type");
    }
}

