/*
 * Decompiled with CFR 0.152.
 */
package org.noear.eggg;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class GenericResolver {
    private static GenericResolver _default = new GenericResolver();

    public static GenericResolver getDefault() {
        return _default;
    }

    public Map<String, Type> createTypeDeepGenericMap(Type type) {
        try {
            ParameterizedType parameterizedType;
            LinkedHashMap<String, Type> typeMap = new LinkedHashMap<String, Type>();
            while (null != type && null != (parameterizedType = this.toParameterizedType(type, typeMap))) {
                Type[] typeArguments = parameterizedType.getActualTypeArguments();
                Class rawType = (Class)parameterizedType.getRawType();
                TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
                for (int i = 0; i < typeParameters.length; ++i) {
                    typeMap.putIfAbsent(typeParameters[i].getTypeName(), typeArguments[i]);
                }
                type = rawType;
            }
            return typeMap;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Can't create generic info: " + type, ex);
        }
    }

    public Map<String, Type> createTypeSelfGenericMap(Type type) {
        try {
            LinkedHashMap<String, Type> typeMap = new LinkedHashMap<String, Type>();
            if (null != type) {
                if (type instanceof Class) {
                    Class type1 = (Class)type;
                    for (TypeVariable tv : type1.getTypeParameters()) {
                        typeMap.put(tv.getTypeName(), tv);
                    }
                } else if (type instanceof ParameterizedType) {
                    ParameterizedType type1 = (ParameterizedType)type;
                    Type[] typeArguments = type1.getActualTypeArguments();
                    Class rawType = (Class)type1.getRawType();
                    TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
                    for (int i = 0; i < typeParameters.length; ++i) {
                        typeMap.put(typeParameters[i].getTypeName(), typeArguments[i]);
                    }
                }
            }
            if (typeMap.isEmpty()) {
                return Collections.emptyMap();
            }
            return typeMap;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Can't create generic info: " + type, ex);
        }
    }

    public ParameterizedType toParameterizedType(Type type, Map<String, Type> genericInfo) {
        if (type == null) {
            return null;
        }
        ParameterizedType result = null;
        if (type instanceof ParameterizedType) {
            result = (ParameterizedType)type;
            if (genericInfo != null && genericInfo.size() > 0) {
                boolean typeArgsChanged = false;
                Type[] typeArgs = result.getActualTypeArguments();
                Class rawClz = (Class)result.getRawType();
                for (int i = 0; i < typeArgs.length; ++i) {
                    Type typeArg1 = typeArgs[i];
                    if (!(typeArg1 instanceof TypeVariable) || (typeArg1 = genericInfo.get(typeArg1.getTypeName())) == null) continue;
                    typeArgsChanged = true;
                    typeArgs[i] = typeArg1;
                }
                if (typeArgsChanged) {
                    result = new ParameterizedTypeImpl(rawClz, typeArgs, result.getOwnerType());
                }
            }
        } else if (type instanceof Class) {
            Type[] genericInterfaces;
            Class clazz = (Class)type;
            Type genericSuper = clazz.getGenericSuperclass();
            if ((null == genericSuper || Object.class.equals((Object)genericSuper)) && (genericInterfaces = clazz.getGenericInterfaces()) != null && genericInterfaces.length > 0) {
                genericSuper = genericInterfaces[0];
            }
            result = this.toParameterizedType(genericSuper, genericInfo);
        }
        return result;
    }

    public Type reviewType(Type type, Map<String, Type> genericInfo) {
        return this.reviewType(type, genericInfo, new HashSet<Type>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Type reviewType(Type type, Map<String, Type> genericInfo, Set<Type> visited) {
        if (genericInfo == null || genericInfo.isEmpty() || type instanceof Class) {
            return type;
        }
        if (!visited.add(type)) {
            return type;
        }
        try {
            if (type instanceof TypeVariable) {
                Type resolved = genericInfo.get(type.getTypeName());
                Type type2 = resolved != null ? this.reviewType(resolved, genericInfo, visited) : type;
                return type2;
            }
            if (type instanceof WildcardType) {
                Type type3 = this.reviewWildcardType((WildcardType)type, genericInfo, visited);
                return type3;
            }
            if (type instanceof ParameterizedType) {
                Type type4 = this.reviewParameterizedType((ParameterizedType)type, genericInfo, visited);
                return type4;
            }
            if (type instanceof GenericArrayType) {
                Type type5 = this.reviewGenericArrayType((GenericArrayType)type, genericInfo, visited);
                return type5;
            }
            Type type6 = type;
            return type6;
        }
        finally {
            visited.remove(type);
        }
    }

    private Type reviewWildcardType(WildcardType wildcardType, Map<String, Type> genericInfo, Set<Type> visited) {
        Object[] upperBounds = this.reviewTypes(wildcardType.getUpperBounds(), genericInfo, visited);
        Object[] lowerBounds = this.reviewTypes(wildcardType.getLowerBounds(), genericInfo, visited);
        if (Arrays.equals(upperBounds, wildcardType.getUpperBounds()) && Arrays.equals(lowerBounds, wildcardType.getLowerBounds())) {
            return wildcardType;
        }
        return new WildcardTypeImpl((Type[])upperBounds, (Type[])lowerBounds);
    }

    private Type reviewParameterizedType(ParameterizedType parameterizedType, Map<String, Type> genericInfo, Set<Type> visited) {
        Object[] typeArgs = this.reviewTypes(parameterizedType.getActualTypeArguments(), genericInfo, visited);
        if (Arrays.equals(typeArgs, parameterizedType.getActualTypeArguments())) {
            return parameterizedType;
        }
        return new ParameterizedTypeImpl((Class)parameterizedType.getRawType(), (Type[])typeArgs, parameterizedType.getOwnerType());
    }

    private Type reviewGenericArrayType(GenericArrayType genericArrayType, Map<String, Type> genericInfo, Set<Type> visited) {
        Type componentType = this.reviewType(genericArrayType.getGenericComponentType(), genericInfo, visited);
        if (componentType == genericArrayType.getGenericComponentType()) {
            return genericArrayType;
        }
        return new GenericArrayTypeImpl(componentType);
    }

    private Type[] reviewTypes(Type[] types, Map<String, Type> genericInfo, Set<Type> visited) {
        Type[] result = new Type[types.length];
        boolean changed = false;
        for (int i = 0; i < types.length; ++i) {
            result[i] = this.reviewType(types[i], genericInfo, visited);
            if (result[i] == types[i]) continue;
            changed = true;
        }
        return changed ? result : types;
    }

    public static class ParameterizedTypeImpl
    implements ParameterizedType {
        private final Class<?> rawType;
        private final Type[] actualTypeArguments;
        private final Type ownerType;

        public ParameterizedTypeImpl(Class<?> rawType, Type[] actualTypeArguments) {
            this(rawType, actualTypeArguments, null);
        }

        public ParameterizedTypeImpl(Class<?> rawType, Type[] actualTypeArguments, Type ownerType) {
            this.rawType = Objects.requireNonNull(rawType, "rawType");
            this.actualTypeArguments = actualTypeArguments != null ? actualTypeArguments : new Type[]{};
            this.ownerType = ownerType;
            TypeVariable<Class<?>>[] typeParameters = rawType.getTypeParameters();
            if (typeParameters.length != this.actualTypeArguments.length) {
                throw new IllegalArgumentException("Argument length mismatch");
            }
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.actualTypeArguments;
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        @Override
        public Type getOwnerType() {
            return this.ownerType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ParameterizedType)) {
                return false;
            }
            ParameterizedType that = (ParameterizedType)o;
            return Objects.equals(this.rawType, that.getRawType()) && Arrays.equals(this.actualTypeArguments, that.getActualTypeArguments()) && Objects.equals(this.ownerType, that.getOwnerType());
        }

        public int hashCode() {
            int result = Objects.hashCode(this.rawType);
            result = 31 * result + Arrays.hashCode(this.actualTypeArguments);
            result = 31 * result + Objects.hashCode(this.ownerType);
            return result;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.ownerType != null) {
                sb.append(this.ownerType.getTypeName()).append("$");
            }
            sb.append(this.rawType.getTypeName());
            if (this.actualTypeArguments.length > 0) {
                sb.append("<");
                for (int i = 0; i < this.actualTypeArguments.length; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    Type arg = this.actualTypeArguments[i];
                    sb.append(arg.getTypeName());
                }
                sb.append(">");
            }
            return sb.toString();
        }
    }

    public static class WildcardTypeImpl
    implements WildcardType {
        private Type[] upperBounds;
        private Type[] lowerBounds;

        public WildcardTypeImpl(Type[] upperBounds, Type[] lowerBounds) {
            this.upperBounds = upperBounds != null ? upperBounds : new Type[]{};
            Type[] typeArray = this.lowerBounds = lowerBounds != null ? lowerBounds : new Type[]{};
            if (this.upperBounds.length == 0) {
                this.upperBounds = new Type[]{Object.class};
            }
            if (this.lowerBounds.length > 0 && (this.upperBounds.length <= 0 || this.upperBounds[0] != Object.class)) {
                throw new IllegalArgumentException("Wildcard cannot have both lower and upper bounds");
            }
        }

        @Override
        public Type[] getUpperBounds() {
            return this.upperBounds;
        }

        @Override
        public Type[] getLowerBounds() {
            return this.lowerBounds;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof WildcardType)) {
                return false;
            }
            WildcardType that = (WildcardType)o;
            return Arrays.equals(this.getUpperBounds(), that.getUpperBounds()) && Arrays.equals(this.getLowerBounds(), that.getLowerBounds());
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.upperBounds);
            result = 31 * result + Arrays.hashCode(this.lowerBounds);
            return result;
        }

        public String toString() {
            if (this.lowerBounds.length > 0) {
                return "? super " + this.boundsToString(this.lowerBounds);
            }
            if (this.isUnbounded()) {
                return "?";
            }
            return "? extends " + this.boundsToString(this.upperBounds);
        }

        private boolean isUnbounded() {
            return this.upperBounds.length == 0 || this.upperBounds.length == 1 && (this.upperBounds[0] == Object.class || this.upperBounds[0].getTypeName().equals("java.lang.Object"));
        }

        private String boundsToString(Type[] bounds) {
            if (bounds.length == 1) {
                return this.getTypeName(bounds[0]);
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < bounds.length; ++i) {
                if (i > 0) {
                    sb.append(" & ");
                }
                sb.append(this.getTypeName(bounds[i]));
            }
            return sb.toString();
        }

        private String getTypeName(Type type) {
            if (type instanceof Class) {
                return ((Class)type).getName();
            }
            return type.getTypeName();
        }
    }

    public static class GenericArrayTypeImpl
    implements GenericArrayType {
        private final Type genericComponentType;

        public GenericArrayTypeImpl(Type genericComponentType) {
            this.genericComponentType = Objects.requireNonNull(genericComponentType, "genericComponentType");
        }

        @Override
        public Type getGenericComponentType() {
            return this.genericComponentType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof GenericArrayType)) {
                return false;
            }
            GenericArrayType that = (GenericArrayType)o;
            return Objects.equals(this.genericComponentType, that.getGenericComponentType());
        }

        public int hashCode() {
            return Objects.hash(this.genericComponentType);
        }

        public String toString() {
            return this.genericComponentType.getTypeName() + "[]";
        }
    }
}

