/*
 * Decompiled with CFR 0.152.
 */
package org.noear.eggg;

import java.lang.annotation.Annotation;
import java.lang.ref.SoftReference;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.eggg.AliasHandler;
import org.noear.eggg.AnnotatedEggg;
import org.noear.eggg.ClassEggg;
import org.noear.eggg.ConstrEggg;
import org.noear.eggg.CreatorMatcher;
import org.noear.eggg.DigestHandler;
import org.noear.eggg.ExecutableEggg;
import org.noear.eggg.FieldEggg;
import org.noear.eggg.GenericResolver;
import org.noear.eggg.MethodEggg;
import org.noear.eggg.ParamEggg;
import org.noear.eggg.PropertyMethodEggg;
import org.noear.eggg.ReflectHandler;
import org.noear.eggg.ReflectHandlerDefault;
import org.noear.eggg.TypeEggg;

public class Eggg {
    private final Map<Type, SoftReference<TypeEggg>> typeEgggCached = new ConcurrentHashMap<Type, SoftReference<TypeEggg>>();
    private final Map<TypeEggg, SoftReference<ClassEggg>> classEgggCached = new ConcurrentHashMap<TypeEggg, SoftReference<ClassEggg>>();
    private GenericResolver genericResolver = GenericResolver.getDefault();
    private AliasHandler aliasHandler;
    private DigestHandler digestHandler;
    private ReflectHandler reflectHandler = ReflectHandlerDefault.getInstance();
    private CreatorMatcher creatorMatcher;

    public Eggg withCreatorClass(Class<? extends Annotation> creatorClass) {
        Objects.requireNonNull(creatorClass, "creatorClass");
        this.creatorMatcher = (e, s) -> s.isAnnotationPresent(creatorClass);
        return this;
    }

    public Eggg withCreatorMatcher(CreatorMatcher creatorMatcher) {
        Objects.requireNonNull(creatorMatcher, "creatorMatcher");
        this.creatorMatcher = creatorMatcher;
        return this;
    }

    public Eggg withAliasHandler(AliasHandler aliasHandler) {
        Objects.requireNonNull(aliasHandler, "aliasHandler");
        this.aliasHandler = aliasHandler;
        return this;
    }

    public Eggg withDigestHandler(DigestHandler digestHandler) {
        Objects.requireNonNull(digestHandler, "digestHandler");
        this.digestHandler = digestHandler;
        return this;
    }

    public Eggg withReflectHandler(ReflectHandler reflectHandler) {
        Objects.requireNonNull(reflectHandler, "reflectHandler");
        this.reflectHandler = reflectHandler;
        return this;
    }

    public Eggg withGenericResolver(GenericResolver genericResolver) {
        Objects.requireNonNull(genericResolver, "genericResolver");
        this.genericResolver = genericResolver;
        return this;
    }

    public void clear() {
        this.typeEgggCached.clear();
        this.classEgggCached.clear();
    }

    public TypeEggg getTypeEggg(Type type) {
        Class clazz;
        Objects.requireNonNull(type, "type");
        if (type instanceof Class && type instanceof Class && (clazz = (Class)type).isAnonymousClass()) {
            type = clazz.getGenericSuperclass();
        }
        return (TypeEggg)this.typeEgggCached.compute(type, (t, softRef) -> {
            if (softRef != null && softRef.get() != null) {
                return softRef;
            }
            return new SoftReference<TypeEggg>(this.newTypeEggg((Type)t));
        }).get();
    }

    public ClassEggg getClassEggg(TypeEggg typeEggg) {
        Objects.requireNonNull(typeEggg, "typeEggg");
        return (ClassEggg)this.classEgggCached.compute(typeEggg, (t, softRef) -> {
            if (softRef != null && softRef.get() != null) {
                return softRef;
            }
            return new SoftReference<ClassEggg>(this.newClassEggg((TypeEggg)t));
        }).get();
    }

    public ClassEggg getClassEggg(Type type) {
        return this.getTypeEggg(type).getClassEggg();
    }

    public TypeEggg newTypeEggg(Type type) {
        try {
            return new TypeEggg(this, type);
        }
        catch (Throwable e) {
            throw new IllegalStateException("The type eggg failed: " + type.getTypeName(), e);
        }
    }

    public ClassEggg newClassEggg(TypeEggg typeEggg) {
        try {
            return new ClassEggg(this, typeEggg);
        }
        catch (Throwable e) {
            throw new IllegalStateException("The class eggg failed: " + typeEggg.getType().getTypeName(), e);
        }
    }

    public FieldEggg newFieldEggg(ClassEggg classEggg, Field field) {
        return new FieldEggg(this, classEggg, field);
    }

    public MethodEggg newMethodEggg(ClassEggg classEggg, Method method) {
        return new MethodEggg(this, classEggg, method);
    }

    public ConstrEggg newConstrEggg(ClassEggg classEggg, Executable constr, boolean isCreator) {
        return new ConstrEggg(this, classEggg, constr, isCreator);
    }

    public PropertyMethodEggg newPropertyMethodEggg(ClassEggg classEggg, MethodEggg methodEggg) {
        return new PropertyMethodEggg(this, classEggg, methodEggg);
    }

    public ParamEggg newParamEggg(ClassEggg classEggg, ExecutableEggg execEggg, Parameter param) {
        return new ParamEggg(this, classEggg, execEggg, param);
    }

    public Map<String, Type> findGenericInfo(TypeEggg owner, Class<?> declaringClass) {
        Type superType;
        if (declaringClass == owner.getType()) {
            return owner.getGenericInfo();
        }
        if (declaringClass.isInterface()) {
            for (Type superInte : owner.getType().getGenericInterfaces()) {
                Type superType2 = this.genericResolver.reviewType(superInte, owner.getGenericInfo());
                TypeEggg superTypeEggg = this.getTypeEggg(superType2);
                if (!declaringClass.isAssignableFrom(superTypeEggg.getType())) continue;
                return this.findGenericInfo(superTypeEggg, declaringClass);
            }
        }
        if ((superType = this.genericResolver.reviewType(owner.getType().getGenericSuperclass(), owner.getGenericInfo())) == null || superType == Object.class) {
            return owner.getGenericInfo();
        }
        return this.findGenericInfo(this.getTypeEggg(superType), declaringClass);
    }

    public List<Type> findGenericList(TypeEggg owner, Class<?> declaringClass) {
        Map<String, Type> map = this.findGenericInfo(owner, declaringClass);
        if (map.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<Type>(map.values());
    }

    protected Object findDigest(ClassEggg classEggg, AnnotatedEggg source, Object defaultValue) {
        if (this.digestHandler == null) {
            return defaultValue;
        }
        return this.digestHandler.apply(classEggg, source, defaultValue);
    }

    protected String findAlias(ClassEggg classEggg, AnnotatedEggg source, String defaultValue) {
        if (this.aliasHandler == null) {
            return defaultValue;
        }
        return this.aliasHandler.apply(classEggg, source, defaultValue);
    }

    protected boolean findCreator(Executable executable) {
        if (this.creatorMatcher == null) {
            return false;
        }
        return this.creatorMatcher.apply(this, executable);
    }

    protected Field[] getDeclaredFields(Class<?> clazz) {
        return this.reflectHandler.getDeclaredFields(clazz);
    }

    protected Method[] getDeclaredMethods(Class<?> clazz) {
        return this.reflectHandler.getDeclaredMethods(clazz);
    }

    protected Method[] getMethods(Class<?> clazz) {
        return this.reflectHandler.getMethods(clazz);
    }

    protected Map<String, Type> createGenericInfo(Type type) {
        return this.genericResolver.createTypeSelfGenericMap(type);
    }

    protected Type reviewType(Type type, Map<String, Type> genericInfo) {
        return this.genericResolver.reviewType(type, genericInfo);
    }
}

