/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial.index.curves;

import org.neo4j.gis.spatial.index.curves.StandardConfiguration;

public class PartialOverlapConfiguration
extends StandardConfiguration {
    private static double TOP_THRESHOLD = 0.99;
    private static double BOTTOM_THRESHOLD = 0.5;
    private double topThreshold;
    private double bottomThreshold;

    public PartialOverlapConfiguration() {
        this(1, TOP_THRESHOLD, BOTTOM_THRESHOLD);
    }

    public PartialOverlapConfiguration(int extraLevels, double topThreshold, double bottomThreshold) {
        super(extraLevels);
        this.topThreshold = topThreshold;
        this.bottomThreshold = bottomThreshold;
    }

    @Override
    public boolean stopAtThisDepth(double overlap, int depth, int maxDepth) {
        double slope = (this.bottomThreshold - this.topThreshold) / (double)maxDepth;
        double threshold = slope * (double)depth + this.topThreshold;
        return overlap >= threshold || depth >= maxDepth;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.extraLevels + "," + this.topThreshold + "," + this.bottomThreshold + ")";
    }
}

