/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.http.driver;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;
import org.neo4j.ogm.config.Configuration;
import org.neo4j.ogm.config.ObjectMapperFactory;
import org.neo4j.ogm.driver.AbstractConfigurableDriver;
import org.neo4j.ogm.drivers.http.request.HttpRequest;
import org.neo4j.ogm.drivers.http.request.HttpRequestException;
import org.neo4j.ogm.drivers.http.transaction.HttpTransaction;
import org.neo4j.ogm.request.DefaultRequest;
import org.neo4j.ogm.request.OptimisticLockingConfig;
import org.neo4j.ogm.request.Request;
import org.neo4j.ogm.request.Statement;
import org.neo4j.ogm.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpDriver
extends AbstractConfigurableDriver {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpDriver.class);
    private final ObjectMapper mapper = ObjectMapperFactory.objectMapper();
    private CloseableHttpClient httpClient;

    public HttpDriver() {
    }

    public HttpDriver(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void configure(Configuration config) {
        super.configure(config);
        if (config.getVerifyConnection().booleanValue()) {
            this.httpClient();
            HttpRequest request = new HttpRequest(this.httpClient(), this.requestUrl(), this.configuration.getCredentials(), true);
            request.execute(new VerifyRequest());
        }
    }

    public synchronized void close() {
        try {
            LOGGER.info("Shutting down Http driver {} ", (Object)this);
            if (this.httpClient != null) {
                this.httpClient.close();
            }
        }
        catch (Exception e) {
            LOGGER.warn("Unexpected Exception when closing http client httpClient: ", (Throwable)e);
        }
    }

    public Request request() {
        Transaction tx = this.transactionManager.getCurrentTransaction();
        if (tx == null) {
            return new HttpRequest(this.httpClient(), this.requestUrl(), this.configuration.getCredentials());
        }
        return new HttpRequest(this.httpClient(), this.requestUrl(), this.configuration.getCredentials(), tx.isReadOnly());
    }

    public Transaction newTransaction(Transaction.Type type, Iterable<String> bookmarks) {
        if (bookmarks != null && bookmarks.iterator().hasNext()) {
            LOGGER.warn("Passing bookmarks {} to HttpDriver. This is not currently supported.", bookmarks);
        }
        return new HttpTransaction(this.transactionManager, this, this.newTransactionUrl(type), type);
    }

    /*
     * Exception decompiling
     */
    public CloseableHttpResponse executeHttpRequest(HttpRequestBase request) throws HttpRequestException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String newTransactionUrl(Transaction.Type type) {
        String url = this.transactionEndpoint(this.configuration.getURI());
        LOGGER.debug("Thread: {}, POST {}", (Object)Thread.currentThread().getId(), (Object)url);
        HttpPost request = new HttpPost(url);
        request.setHeader("X-WRITE", type == Transaction.Type.READ_ONLY ? "0" : "1");
        try (CloseableHttpResponse response = this.executeHttpRequest((HttpRequestBase)request);){
            Header location = response.getHeaders("Location")[0];
            String string = location.getValue();
            return string;
        }
        catch (IOException ioe) {
            throw new HttpRequestException((HttpRequestBase)request, ioe);
        }
    }

    private String autoCommitUrl() {
        return this.transactionEndpoint(this.configuration.getURI()).concat("/commit");
    }

    private String transactionEndpoint(String server) {
        if (server == null) {
            return null;
        }
        String url = server;
        if (!server.endsWith("/")) {
            url = url + "/";
        }
        return url + "db/data/transaction";
    }

    private String requestUrl() {
        if (this.transactionManager != null) {
            Transaction tx = this.transactionManager.getCurrentTransaction();
            if (tx != null) {
                LOGGER.debug("Thread: {}, request url {}", (Object)Thread.currentThread().getId(), (Object)((HttpTransaction)tx).url());
                return ((HttpTransaction)tx).url();
            }
            LOGGER.debug("Thread: {}, No current transaction, using auto-commit", (Object)Thread.currentThread().getId());
        } else {
            LOGGER.debug("Thread: {}, No transaction manager available, using auto-commit", (Object)Thread.currentThread().getId());
        }
        LOGGER.debug("Thread: {}, request url {}", (Object)Thread.currentThread().getId(), (Object)this.autoCommitUrl());
        return this.autoCommitUrl();
    }

    public boolean readOnly() {
        Transaction tx;
        if (this.transactionManager != null && (tx = this.transactionManager.getCurrentTransaction()) != null) {
            return tx.isReadOnly();
        }
        return false;
    }

    public boolean requiresTransaction() {
        return false;
    }

    private synchronized CloseableHttpClient httpClient() {
        if (this.httpClient == null) {
            try {
                HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
                SSLContext sslContext = SSLContext.getDefault();
                if (this.configuration.getTrustStrategy() != null && this.configuration.getTrustStrategy().equals("ACCEPT_UNSIGNED")) {
                    sslContext = new SSLContextBuilder().loadTrustMaterial(null, (arg0, arg1) -> true).build();
                    LOGGER.warn("Certificate validation has been disabled");
                }
                httpClientBuilder.setSSLContext(sslContext);
                HostnameVerifier hostnameVerifier = SSLConnectionSocketFactory.getDefaultHostnameVerifier();
                SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, hostnameVerifier);
                Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslSocketFactory).build();
                PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
                Integer connectionPoolSize = this.configuration.getConnectionPoolSize();
                connectionManager.setMaxTotal(connectionPoolSize.intValue());
                connectionManager.setDefaultMaxPerRoute(connectionPoolSize.intValue());
                httpClientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager);
                this.httpClient = httpClientBuilder.build();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.httpClient;
    }

    private static class VerifyRequest
    implements DefaultRequest {
        private VerifyRequest() {
        }

        public List<Statement> getStatements() {
            return Collections.singletonList(new Statement(){

                public String getStatement() {
                    return "RETURN 1";
                }

                public Map<String, Object> getParameters() {
                    return Collections.emptyMap();
                }

                public String[] getResultDataContents() {
                    return new String[0];
                }

                public boolean isIncludeStats() {
                    return false;
                }

                public Optional<OptimisticLockingConfig> optimisticLockingConfig() {
                    return Optional.empty();
                }
            });
        }
    }
}

