/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.reader;

import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.helpers.TaskCoordinator;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.exceptions.index.IndexNotApplicableKernelException;
import org.neo4j.kernel.api.impl.index.partition.PartitionSearcher;
import org.neo4j.kernel.api.impl.index.sampler.AggregatingIndexSampler;
import org.neo4j.kernel.api.impl.schema.reader.IndexReaderCloseException;
import org.neo4j.kernel.api.impl.schema.reader.SimpleIndexReader;
import org.neo4j.kernel.api.schema.IndexQuery;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSampler;
import org.neo4j.values.storable.Value;

public class PartitionedIndexReader
implements IndexReader {
    private final List<SimpleIndexReader> indexReaders;

    public PartitionedIndexReader(List<PartitionSearcher> partitionSearchers, IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, TaskCoordinator taskCoordinator) {
        this(partitionSearchers.stream().map(partitionSearcher -> new SimpleIndexReader((PartitionSearcher)partitionSearcher, descriptor, samplingConfig, taskCoordinator)).collect(Collectors.toList()));
    }

    PartitionedIndexReader(List<SimpleIndexReader> readers) {
        this.indexReaders = readers;
    }

    public PrimitiveLongIterator query(IndexQuery ... predicates) throws IndexNotApplicableKernelException {
        try {
            return this.partitionedOperation(reader -> this.innerQuery((IndexReader)reader, predicates));
        }
        catch (InnerException e) {
            throw e.getCause();
        }
    }

    public boolean hasFullNumberPrecision(IndexQuery ... predicates) {
        return false;
    }

    private PrimitiveLongIterator innerQuery(IndexReader reader, IndexQuery[] predicates) {
        try {
            return reader.query(predicates);
        }
        catch (IndexNotApplicableKernelException e) {
            throw new InnerException(e);
        }
    }

    public long countIndexedNodes(long nodeId, Value ... propertyValues) {
        return this.indexReaders.parallelStream().mapToLong(reader -> reader.countIndexedNodes(nodeId, propertyValues)).sum();
    }

    public IndexSampler createSampler() {
        List<IndexSampler> indexSamplers = this.indexReaders.parallelStream().map(SimpleIndexReader::createSampler).collect(Collectors.toList());
        return new AggregatingIndexSampler(indexSamplers);
    }

    public void close() {
        try {
            IOUtils.closeAll(this.indexReaders);
        }
        catch (IOException e) {
            throw new IndexReaderCloseException(e);
        }
    }

    private PrimitiveLongIterator partitionedOperation(Function<SimpleIndexReader, PrimitiveLongIterator> readerFunction) {
        return PrimitiveLongCollections.concat((Iterable)this.indexReaders.parallelStream().map(readerFunction::apply).collect(Collectors.toList()));
    }

    private static final class InnerException
    extends RuntimeException {
        private InnerException(IndexNotApplicableKernelException e) {
            super((Throwable)e);
        }

        public synchronized IndexNotApplicableKernelException getCause() {
            return (IndexNotApplicableKernelException)super.getCause();
        }
    }
}

